/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.menumanager.menu.metatypewrapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import org.cishell.reference.gui.menumanager.menu.metatypewrapper.ParamAD;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ParamOCD
implements ObjectClassDefinition {
    private ObjectClassDefinition realOCD;
    private ParamAD[] allWrappedADs;
    private ParamAD[] requiredWrappedADs;
    private ParamAD[] optionalWrappedADs;
    private LogService log;
    private Dictionary defaultOverrider;

    public ParamOCD(ObjectClassDefinition realOCD, Dictionary defaultOverrider) {
        this.realOCD = realOCD;
        this.defaultOverrider = defaultOverrider;
        this.allWrappedADs = this.wrapAttributeDefinitions(realOCD.getAttributeDefinitions(-1));
        this.requiredWrappedADs = this.wrapAttributeDefinitions(realOCD.getAttributeDefinitions(1));
        this.optionalWrappedADs = this.wrapAttributeDefinitions(realOCD.getAttributeDefinitions(2));
    }

    private ParamAD[] wrapAttributeDefinitions(AttributeDefinition[] realAttributeDefinitions) {
        ParamAD[] wrappedADs = new ParamAD[realAttributeDefinitions.length];
        int i = 0;
        while (i < realAttributeDefinitions.length) {
            ParamAD wrappedAD;
            AttributeDefinition realAD = realAttributeDefinitions[i];
            String[] defaultOverrideValue = this.getDefaultOverrideValue(realAD.getID(), this.defaultOverrider);
            wrappedADs[i] = wrappedAD = new ParamAD(this.log, realAD, defaultOverrideValue);
            ++i;
        }
        return wrappedADs;
    }

    private String[] getDefaultOverrideValue(String overrideKey, Dictionary defaultOverrider) {
        if (defaultOverrider != null) {
            String defaultOverrideValue = (String)defaultOverrider.get(overrideKey);
            if (defaultOverrideValue != null) {
                return new String[]{defaultOverrideValue};
            }
            return null;
        }
        return null;
    }

    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        if (filter == -1) {
            return this.allWrappedADs;
        }
        if (filter == 1) {
            return this.requiredWrappedADs;
        }
        if (filter == 2) {
            return this.optionalWrappedADs;
        }
        this.log.log(2, "Requested filter of unrecognized type " + filter + " in getAttributeDefinitions in ParamOCD. Treating as if your meant to return all attributes");
        return this.allWrappedADs;
    }

    public String getDescription() {
        return this.realOCD.getDescription();
    }

    public String getID() {
        return this.realOCD.getID();
    }

    public InputStream getIcon(int size) throws IOException {
        return this.realOCD.getIcon(size);
    }

    public String getName() {
        return this.realOCD.getName();
    }
}

