/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.persistence.save;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.data.Data;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;
import org.cishell.service.guibuilder.GUIBuilderService;
import org.cishell.utilities.FileUtilities;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class FileSaver {
    public static final String FILE_EXTENSION_PREFIX = "file-ext:";
    private static File currentDir;
    private Shell parent;
    private GUIBuilderService guiBuilder;
    private LogService log;

    public FileSaver(Shell parent, CIShellContext ciShellContext) {
        this.parent = parent;
        this.guiBuilder = (GUIBuilderService)ciShellContext.getService(GUIBuilderService.class.getName());
        this.log = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    private boolean confirmFileOverwrite(File file) {
        String message = "The file:\n" + file.getPath() + "\nalready exists. Are you sure you want to overwrite it?";
        return this.guiBuilder.showConfirm("File Overwrite", message, "");
    }

    private boolean isSaveFileValid(File file) {
        boolean valid = false;
        if (file.isDirectory()) {
            String message = "Destination cannot be a directory. Please choose a file";
            this.guiBuilder.showError("Invalid Destination", message, "");
            valid = false;
        } else {
            valid = file.exists() ? this.confirmFileOverwrite(file) : true;
        }
        return valid;
    }

    public boolean save(Converter converter, Data data) {
        String outDataStr = (String)converter.getProperties().get("out_data");
        String ext = "";
        if (outDataStr.startsWith(FILE_EXTENSION_PREFIX)) {
            ext = outDataStr.substring(FILE_EXTENSION_PREFIX.length());
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        FileDialog dialog = new FileDialog(this.parent, 8192);
        if (currentDir == null) {
            currentDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "anything");
        }
        dialog.setFilterPath(currentDir.getPath());
        if (ext != null && !ext.equals("*")) {
            dialog.setFilterExtensions(new String[]{"*." + ext});
        }
        dialog.setText("Choose File");
        String fileLabel = (String)data.getMetadata().get("Label");
        String suggestedFileName = FileUtilities.extractFileName((String)fileLabel);
        String cleanedSuggestedFileName = FileUtilities.replaceInvalidFilenameCharacters((String)suggestedFileName);
        dialog.setFileName(String.valueOf(cleanedSuggestedFileName) + "." + ext);
        boolean done = false;
        while (!done) {
            String fileName = dialog.open();
            if (fileName != null) {
                File selectedFile = new File(fileName);
                if (!this.isSaveFileValid(selectedFile)) continue;
                if (ext != null && ext.length() != 0 && !selectedFile.getPath().endsWith(ext) && !ext.equals("*")) {
                    selectedFile = new File(String.valueOf(selectedFile.getPath()) + '.' + ext);
                }
                try {
                    Data newData = converter.convert(data);
                    this.copy((File)newData.getData(), selectedFile);
                    currentDir = selectedFile.isDirectory() ? new File(selectedFile + File.separator + "anything") : new File(String.valueOf(selectedFile.getParent()) + File.separator + "anything");
                    done = true;
                }
                catch (ConversionException e) {
                    this.log.log(1, "Error occurred while converting data to saved format:\n    " + e.getMessage(), (Throwable)e);
                    return false;
                }
                this.log.log(3, "Saved: " + selectedFile.getPath());
                continue;
            }
            done = true;
            return false;
        }
        return true;
    }

    private boolean copy(File in, File out) {
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            FileChannel readableChannel = fis.getChannel();
            FileChannel writableChannel = fos.getChannel();
            writableChannel.truncate(0L);
            writableChannel.transferFrom(readableChannel, 0L, readableChannel.size());
            fis.close();
            fos.close();
            return true;
        }
        catch (IOException ioe) {
            this.guiBuilder.showError("Copy Error", "IOException during copy", ioe.getMessage());
            return false;
        }
    }
}

