/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.persistence.save;

import java.io.File;
import org.cishell.app.service.filesaver.FileSaveException;
import org.cishell.app.service.filesaver.FileSaverService;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCanceledException;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class Save
implements Algorithm {
    public static final String SAVE_DIALOG_TITLE = "Save";
    private Data data;
    private LogService logger;
    private FileSaverService fileSaver;

    public Save(Data data, LogService logger, FileSaverService fileSaver) {
        this.data = data;
        this.logger = logger;
        this.fileSaver = fileSaver;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        this.tryToSave(this.data, "file-ext:*");
        return null;
    }

    private void tryToSave(Data outData, String outFormat) throws AlgorithmExecutionException {
        try {
            File outputFile = this.fileSaver.saveData(outData);
            if (outputFile == null) {
                throw new AlgorithmCanceledException("User canceled file saving when choosing the destination of the file.");
            }
            String logMessage = String.format("Saved: %s", outputFile.getPath());
            this.logger.log(3, logMessage);
        }
        catch (FileSaveException e) {
            String logMessage = String.format("Error occurred while converting data to saved format:\n    %s", e.getMessage());
            this.logger.log(1, logMessage, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

