/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.persistence.save;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.AlgorithmProperty;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.guibuilder.swt.builder.AbstractDialog;
import org.cishell.reference.gui.persistence.save.FileSaver;
import org.cishell.service.conversion.Converter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.ServiceReference;

public class SaveDataChooser
extends AbstractDialog
implements AlgorithmProperty {
    public static final Image QUESTION_ICON = Display.getCurrent().getSystemImage(4);
    protected Data data;
    protected Converter[] converters;
    private List converterListComponent;
    private StyledText detailPane;
    CIShellContext ciShellContext;

    public SaveDataChooser(Data data, Shell parent, Converter[] converters, String title, CIShellContext ciShellContext) {
        super(parent, title, QUESTION_ICON);
        this.data = data;
        this.converters = this.alphabetizeConverters(this.filterConverters(converters));
        this.ciShellContext = ciShellContext;
    }

    private Composite initializeGUI(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        Group converterGroup = new Group(content, 0);
        converterGroup.setText("Pick the Output Data Type");
        converterGroup.setLayout((Layout)new FillLayout());
        GridData persisterData = new GridData(1808);
        persisterData.widthHint = 200;
        converterGroup.setLayoutData((Object)persisterData);
        this.converterListComponent = new List((Composite)converterGroup, 772);
        this.initializeConverterListComponent();
        this.converterListComponent.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                List list = (List)mouseEvent.getSource();
                int selection = list.getSelectionIndex();
                if (selection != -1) {
                    SaveDataChooser.this.selectionMade(selection);
                }
            }
        });
        this.converterListComponent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List list = (List)selectionEvent.getSource();
                int selection = list.getSelectionIndex();
                if (selection != -1) {
                    SaveDataChooser.this.updateDetailPane(SaveDataChooser.this.converters[selection]);
                }
            }
        });
        Group detailsGroup = new Group(content, 0);
        detailsGroup.setText("Details");
        detailsGroup.setLayout((Layout)new FillLayout());
        GridData detailsData = new GridData(1808);
        detailsData.widthHint = 200;
        detailsGroup.setLayoutData((Object)detailsData);
        this.detailPane = this.initializeDetailPane(detailsGroup);
        this.converterListComponent.setSelection(0);
        this.updateDetailPane(this.converters[0]);
        return content;
    }

    private void initializeConverterListComponent() {
        int ii = 0;
        while (ii < this.converters.length) {
            if (this.converters[ii] != null) {
                Dictionary converterProperties = this.converters[ii].getProperties();
                String outData = null;
                ServiceReference[] serviceReferences = this.converters[ii].getConverterChain();
                if (serviceReferences != null && serviceReferences.length > 0) {
                    outData = (String)serviceReferences[serviceReferences.length - 1].getProperty("label");
                }
                if (outData == null) {
                    outData = (String)converterProperties.get("label");
                }
                if (outData == null || outData.length() == 0) {
                    outData = this.converters[ii].getClass().getName();
                }
                this.converterListComponent.add(outData);
            }
            ++ii;
        }
    }

    private StyledText initializeDetailPane(Group detailsGroup) {
        StyledText detailPane = new StyledText((Composite)detailsGroup, 768);
        detailPane.setEditable(false);
        detailPane.getCaret().setVisible(false);
        return detailPane;
    }

    private void updateDetailPane(Converter converter) {
        Dictionary converterProperties = converter.getProperties();
        Enumeration converterPropertiesKeys = converterProperties.keys();
        this.detailPane.setText("");
        while (converterPropertiesKeys.hasMoreElements()) {
            Object key = converterPropertiesKeys.nextElement();
            Object value = converterProperties.get(key);
            StyleRange styleRange = new StyleRange();
            styleRange.start = this.detailPane.getText().length();
            this.detailPane.append(key + ":\n");
            styleRange.length = key.toString().length() + 1;
            styleRange.fontStyle = 1;
            this.detailPane.setStyleRange(styleRange);
            this.detailPane.append(value + "\n");
        }
    }

    private Converter[] filterConverters(Converter[] allConverters) {
        HashMap<String, Converter> lastInDataToConverter = new HashMap<String, Converter>();
        int ii = 0;
        while (ii < allConverters.length) {
            Converter converter = allConverters[ii];
            String lastInputData = this.getLastConverterInData(converter);
            if (lastInDataToConverter.containsKey(lastInputData)) {
                Converter alreadyStoredConverter = (Converter)lastInDataToConverter.get(lastInputData);
                Converter chosenConverter = this.returnPreferredConverter(converter, alreadyStoredConverter);
                lastInDataToConverter.put(lastInputData, chosenConverter);
            } else {
                lastInDataToConverter.put(lastInputData, converter);
            }
            ++ii;
        }
        return lastInDataToConverter.values().toArray(new Converter[0]);
    }

    private String getLastConverterInData(Converter converter) {
        ServiceReference[] convChain = converter.getConverterChain();
        if (convChain.length >= 1) {
            ServiceReference lastConverter = convChain[convChain.length - 1];
            String lastInData = (String)lastConverter.getProperty("in_data");
            return lastInData;
        }
        return "";
    }

    private Converter returnPreferredConverter(Converter converter1, Converter converter2) {
        int converter2Length;
        Dictionary converter2Properties;
        String converter2Lossiness;
        int converter2Quality;
        Dictionary converter1Properties = converter1.getProperties();
        String converter1Lossiness = (String)converter1Properties.get("conversion");
        int converter1Quality = this.determineQuality(converter1Lossiness);
        if (converter1Quality > (converter2Quality = this.determineQuality(converter2Lossiness = (String)(converter2Properties = converter2.getProperties()).get("conversion")))) {
            return converter1;
        }
        if (converter2Quality > converter1Quality) {
            return converter2;
        }
        int converter1Length = converter1.getConverterChain().length;
        if (converter1Length > (converter2Length = converter2.getConverterChain().length)) {
            return converter2;
        }
        if (converter2Length > converter1Length) {
            return converter1;
        }
        return converter1;
    }

    private int determineQuality(String lossiness) {
        if (lossiness == "lossy") {
            return 0;
        }
        if (lossiness == null) {
            return 1;
        }
        return 2;
    }

    private Converter[] alphabetizeConverters(Converter[] converters) {
        Arrays.sort(converters, new CompareAlphabetically());
        return converters;
    }

    protected void selectionMade(int selectedIndex) {
        try {
            this.getShell().setVisible(false);
            Converter converter = this.converters[selectedIndex];
            FileSaver saver = new FileSaver(this.getShell(), this.ciShellContext);
            this.close(saver.save(converter, this.data));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void createDialogButtons(Composite parent) {
        Button select = new Button(parent, 8);
        select.setText("Select");
        select.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int index = SaveDataChooser.this.converterListComponent.getSelectionIndex();
                if (index != -1) {
                    SaveDataChooser.this.selectionMade(index);
                }
            }
        });
        select.setFocus();
        Button cancel = new Button(parent, 0);
        cancel.setText("Cancel");
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SaveDataChooser.this.close(false);
            }
        });
    }

    public Composite createContent(Composite parent) {
        if (this.converters.length == 1) {
            FileSaver saver = new FileSaver((Shell)parent, this.ciShellContext);
            this.close(saver.save(this.converters[0], this.data));
            return parent;
        }
        return this.initializeGUI(parent);
    }

    private class CompareAlphabetically
    implements Comparator {
        private CompareAlphabetically() {
        }

        public int compare(Object object1, Object object2) {
            if (object1 instanceof Converter && object2 instanceof Converter) {
                Converter converter1 = (Converter)object1;
                String converter1Label = this.getLabel(converter1);
                Converter converter2 = (Converter)object2;
                String converter2Label = this.getLabel(converter2);
                if (converter1Label != null && converter2Label != null) {
                    return converter1Label.compareTo(converter2Label);
                }
                if (converter1Label == null) {
                    return 1;
                }
                if (converter2Label == null) {
                    return -1;
                }
                return 0;
            }
            throw new IllegalArgumentException("Can only compare Converters");
        }

        private String getLabel(Converter converter) {
            String label = "";
            ServiceReference[] serviceReferences = converter.getConverterChain();
            if (serviceReferences != null && serviceReferences.length > 0) {
                label = (String)serviceReferences[serviceReferences.length - 1].getProperty("label");
            }
            return label;
        }
    }
}

