/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.persistence.view;

import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.persistence.view.core.FileViewer;
import org.cishell.reference.gui.persistence.view.core.exceptiontypes.FileViewingException;
import org.cishell.service.conversion.DataConversionService;
import org.osgi.service.log.LogService;

public class FileView
implements Algorithm {
    private Data[] dataToView;
    private CIShellContext ciShellContext;
    private DataConversionService conversionManager;
    private LogService logger;

    public FileView(Data[] data, CIShellContext ciShellContext, DataConversionService conversionManager, LogService logger) {
        this.dataToView = data;
        this.ciShellContext = ciShellContext;
        this.conversionManager = conversionManager;
        this.logger = logger;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Data[] dataArray = this.dataToView;
        int n = this.dataToView.length;
        int n2 = 0;
        while (n2 < n) {
            Data data = dataArray[n2];
            try {
                FileViewer.viewDataFile(data, this.ciShellContext, this.conversionManager, this.logger);
            }
            catch (FileViewingException fileViewingException) {
                String logMessage = String.format("Error: Unable to view data \"%s\".", data.getMetadata().get("Label"));
                this.logger.log(1, logMessage);
            }
            ++n2;
        }
        return new Data[0];
    }
}

