/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.persistence.view.core;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.cishell.service.database.Database;
import org.cishell.utilities.FileUtilities;

public class DatabaseSchemaOverviewGenerator {
    private static final String newLine = System.getProperty("line.separator");

    public static File generateDatabaseSchemaOverview(Database db) throws Exception {
        Connection dbConnection = db.getConnection();
        String applicationSchemaName = db.getApplicationSchemaName();
        StringBuffer dbOverview = new StringBuffer();
        String headerText = DatabaseSchemaOverviewGenerator.getHeaderText();
        dbOverview.append(headerText);
        List<String> tableNames = DatabaseSchemaOverviewGenerator.getTableNames(dbConnection, applicationSchemaName);
        for (String tableName : tableNames) {
            String tableSchemaText = DatabaseSchemaOverviewGenerator.getTableSchemaAsText(dbConnection, tableName, applicationSchemaName);
            String foreignKeyReferencesText = DatabaseSchemaOverviewGenerator.getForeignKeyReferencesAsText(dbConnection, tableName, applicationSchemaName);
            dbOverview.append(tableSchemaText);
            dbOverview.append(foreignKeyReferencesText);
            dbOverview.append(newLine);
        }
        File dbOverviewFile = FileUtilities.writeTextIntoTemporaryDirectory((String)dbOverview.toString(), (String)"txt");
        return dbOverviewFile;
    }

    private static String getHeaderText() {
        StringBuffer headerText = new StringBuffer();
        headerText.append("Database Tables:" + newLine);
        headerText.append("********************" + newLine);
        headerText.append(newLine);
        headerText.append(newLine);
        return headerText.toString();
    }

    private static String getTableSchemaAsText(Connection dbConnection, String tableName, String applicationSchemaName) throws SQLException {
        StringBuffer tableSchemaAsText = new StringBuffer();
        tableSchemaAsText.append(String.valueOf(tableName) + " (");
        ResultSet columns = dbConnection.getMetaData().getColumns(null, applicationSchemaName, tableName, null);
        while (columns.next()) {
            String columnName = columns.getString("COLUMN_NAME");
            String columnType = columns.getString("TYPE_NAME");
            tableSchemaAsText.append(" " + columnName + " " + columnType + ",");
        }
        tableSchemaAsText.deleteCharAt(tableSchemaAsText.length() - 1);
        tableSchemaAsText.append(")" + newLine);
        return tableSchemaAsText.toString();
    }

    private static String getForeignKeyReferencesAsText(Connection dbConnection, String tableName, String applicationSchemaName) throws SQLException {
        StringBuffer foreignKeyReferencesAsText = new StringBuffer();
        ResultSet foreignKeys = dbConnection.getMetaData().getImportedKeys(null, applicationSchemaName, tableName);
        while (foreignKeys.next()) {
            String foreignKey = foreignKeys.getString("FKCOLUMN_NAME");
            String referencedTable = foreignKeys.getString("PKTABLE_NAME");
            String referencedTableKey = foreignKeys.getString("PKCOLUMN_NAME");
            foreignKeyReferencesAsText.append("    " + foreignKey + " -----> " + referencedTable + "." + referencedTableKey);
            foreignKeyReferencesAsText.append(newLine);
        }
        return foreignKeyReferencesAsText.toString();
    }

    private static List<String> getTableNames(Connection dbConnection, String defaultSchemaName) throws SQLException {
        DatabaseMetaData dbMetadata = dbConnection.getMetaData();
        ResultSet allTableNames = dbMetadata.getTables(null, defaultSchemaName, null, null);
        ArrayList<String> nonSystemTableNames = new ArrayList<String>();
        while (allTableNames.next()) {
            String schemaName = allTableNames.getString("TABLE_SCHEM");
            if (!DatabaseSchemaOverviewGenerator.isNonSystemSchemaName(schemaName, defaultSchemaName)) continue;
            String tableName = allTableNames.getString("TABLE_NAME");
            nonSystemTableNames.add(tableName);
        }
        return nonSystemTableNames;
    }

    private static boolean isNonSystemSchemaName(String tableSchemaName, String defaultSchemaName) {
        return tableSchemaName.indexOf(defaultSchemaName) != -1;
    }
}

