/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.persistence.view.core;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.persistence.view.core.DatabaseSchemaOverviewGenerator;
import org.cishell.reference.gui.persistence.view.core.ViewDataChooser;
import org.cishell.reference.gui.persistence.view.core.exceptiontypes.ConvertDataForViewingException;
import org.cishell.reference.gui.persistence.view.core.exceptiontypes.FileViewingException;
import org.cishell.reference.gui.persistence.view.core.exceptiontypes.NoProgramFoundException;
import org.cishell.reference.gui.persistence.view.core.exceptiontypes.UserCanceledDataViewSelectionException;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;
import org.cishell.service.conversion.DataConversionService;
import org.cishell.service.database.Database;
import org.cishell.utilities.FileCopyingException;
import org.cishell.utilities.FileUtilities;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.log.LogService;

public class FileViewer {
    public static final String FILE_EXTENSION_MIME_TYPE_PREFIX = "file-ext:";
    public static final String ANY_FILE_EXTENSION_FILTER = "file-ext:*";
    public static final String FILE_EXTENSION_PREFIX = "file-ext:";
    public static final String ANY_MIME_TYPE = "file:";
    public static final String CSV_FILE_EXT = "file-ext:csv";
    public static final String CSV_MIME_TYPE = "file:text/csv";
    public static final String TEMPORARY_CSV_FILE_NAME = "CSV-";
    public static final String CSV_FILE_EXTENSION = "csv";
    public static final String TXT_FILE_EXTENSION = "txt";
    public static final String ANY_FILE_FORMAT_PATTERN = "(file:.*)|(file-ext:.*)";

    public static void viewDataFile(Data data, CIShellContext ciShellContext, DataConversionService conversionManager, LogService logger) throws FileViewingException {
        FileViewer.viewDataFileWithProgram(data, "", ciShellContext, conversionManager, logger);
    }

    public static void viewDataFileWithProgram(Data data, String customFileExtension, CIShellContext ciShellContext, DataConversionService converterManager, LogService logger) throws FileViewingException {
        FileWithExtension fileWithExtension = FileViewer.convertDataForViewing(data, ciShellContext, converterManager, logger);
        FileViewer.viewFileWithExtension(fileWithExtension, customFileExtension);
    }

    private static FileWithExtension convertDataForViewing(Data data, CIShellContext ciShellContext, DataConversionService converterManager, LogService logger) throws FileViewingException {
        try {
            String dataFormat = data.getFormat();
            if (FileViewer.dataIsDB(data, converterManager)) {
                try {
                    Data genericDBData = converterManager.convert(data, "db:any");
                    Database genericDatabase = (Database)genericDBData.getData();
                    File dbSchemaOverview = DatabaseSchemaOverviewGenerator.generateDatabaseSchemaOverview(genericDatabase);
                    return new FileWithExtension(dbSchemaOverview, TXT_FILE_EXTENSION);
                }
                catch (ConversionException conversionException) {
                }
                catch (Exception e) {
                    String message = "Unexpected error occurred while generating database schema overview. Attempting to view the data itemby other means.";
                    logger.log(2, message, (Throwable)e);
                }
            }
            if (FileViewer.isCSVFormat(data)) {
                try {
                    File csvFileForViewing = FileUtilities.createTemporaryFileCopy((File)((File)data.getData()), (String)TEMPORARY_CSV_FILE_NAME, (String)CSV_FILE_EXTENSION);
                    return new FileWithExtension(csvFileForViewing, CSV_FILE_EXTENSION);
                }
                catch (FileCopyingException csvFileCopyingException) {
                    throw new ConvertDataForViewingException(csvFileCopyingException);
                }
            }
            if (FileViewer.dataIsCSVCompatible(data, converterManager)) {
                File preparedFileForViewing = FileViewer.prepareFileForViewing(data, CSV_FILE_EXTENSION, converterManager);
                return new FileWithExtension(preparedFileForViewing, CSV_FILE_EXTENSION);
            }
            if (FileViewer.dataIsFile(data, dataFormat)) {
                return new FileWithExtension(FileViewer.prepareTextFileForViewing(data), TXT_FILE_EXTENSION);
            }
            if (FileViewer.convertersExist(data, ANY_FILE_EXTENSION_FILTER, converterManager)) {
                return new FileWithExtension(FileViewer.convertDataToTextFile(data, converterManager, ciShellContext), TXT_FILE_EXTENSION);
            }
            String exceptionMessage = String.format("No converters exist for the data \"%s\".", data.getMetadata().get("Label"));
            throw new ConvertDataForViewingException(exceptionMessage);
        }
        catch (ConvertDataForViewingException e) {
            String exceptionMessage = String.format("There was a problem when preparing the data \"%s\" for viewing.", data.getMetadata().get("Label"));
            throw new FileViewingException(exceptionMessage, e);
        }
    }

    private static void viewFileWithExtension(FileWithExtension fileWithExtension, String customFileExtension) throws FileViewingException {
        try {
            Program program = FileViewer.selectChosenProgramForFileExtension(fileWithExtension.fileExtension, customFileExtension);
            FileViewer.executeProgramWithFile(program, fileWithExtension.file);
        }
        catch (NoProgramFoundException noProgramFoundException) {
            String exceptionMessage = String.format("Could not view the file \"%s\" because no viewing program could be found for it.", fileWithExtension.file.getAbsolutePath());
            throw new FileViewingException(exceptionMessage, noProgramFoundException);
        }
    }

    private static boolean isCSVFormat(Data data) {
        String dataFormat = data.getFormat();
        return dataFormat.startsWith(CSV_MIME_TYPE) || dataFormat.startsWith(CSV_FILE_EXT);
    }

    private static boolean dataIsCSVCompatible(Data data, DataConversionService converterManager) {
        return FileViewer.isCSVFormat(data) || FileViewer.convertersExist(data, CSV_FILE_EXT, converterManager);
    }

    private static boolean dataIsDB(Data data, DataConversionService converterManager) {
        return FileViewer.has_DB_MimeType_Prefix(data) || FileViewer.convertersExist(data, "db:any", converterManager);
    }

    private static boolean has_DB_MimeType_Prefix(Data data) {
        return data.getFormat().startsWith("db:");
    }

    private static boolean dataIsFile(Data data, String dataFormat) {
        return data.getData() instanceof File || dataFormat.startsWith(ANY_MIME_TYPE) || dataFormat.startsWith("file-ext:");
    }

    private static boolean convertersExist(Data data, String targetFormat, DataConversionService conversionManager) {
        Converter[] converters = conversionManager.findConverters(data, targetFormat);
        return converters.length > 0;
    }

    private static File prepareFileForViewing(Data originalData, String fileExtension, DataConversionService converterManager) throws ConvertDataForViewingException {
        String dataLabel = (String)originalData.getMetadata().get("Label");
        try {
            String fileExtensionMimeType = "file-ext:" + fileExtension;
            File convertedFile = FileViewer.convertToFile(originalData, fileExtensionMimeType, converterManager);
            String fileName = FileUtilities.extractFileName((String)dataLabel);
            String cleanedFileName = FileUtilities.replaceInvalidFilenameCharacters((String)fileName);
            return FileUtilities.createTemporaryFileCopy((File)convertedFile, (String)cleanedFileName, (String)fileExtension);
        }
        catch (ConversionException e) {
            String exceptionMessage = String.format("A ConversionException occurred when converting the data \"%s\" to %s.", dataLabel, fileExtension);
            throw new ConvertDataForViewingException(exceptionMessage, e);
        }
        catch (FileCopyingException temporaryFileCopyingException) {
            String exceptionMessage = String.format("A FileCopyingException occurred when converting the data \"%s\" to %s.", dataLabel, fileExtension);
            throw new ConvertDataForViewingException(exceptionMessage, temporaryFileCopyingException);
        }
    }

    private static File prepareTextFileForViewing(Data originalData) throws ConvertDataForViewingException {
        String dataLabel = (String)originalData.getMetadata().get("Label");
        String dataFormat = originalData.getFormat();
        String suggestedFileName = FileUtilities.extractFileName((String)dataLabel);
        String cleanedSuggestedFileName = FileUtilities.replaceInvalidFilenameCharacters((String)suggestedFileName);
        String fileExtension = FileUtilities.extractExtension((String)dataFormat);
        try {
            File fileToView = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)cleanedSuggestedFileName, (String)fileExtension);
            FileUtilities.copyFile((File)((File)originalData.getData()), (File)fileToView);
            return fileToView;
        }
        catch (IOException temporaryFileCreationException) {
            String exceptionMessage = "An IOException occurred when creating the temporary file \"" + cleanedSuggestedFileName + "." + fileExtension + "\" for viewing the data \"" + dataLabel + "\".";
            throw new ConvertDataForViewingException(exceptionMessage, temporaryFileCreationException);
        }
        catch (FileCopyingException fileCopyingException) {
            throw new ConvertDataForViewingException(fileCopyingException);
        }
    }

    private static File convertDataToTextFile(Data originalData, DataConversionService converterManager, CIShellContext ciShellContext) throws ConvertDataForViewingException {
        Converter[] converters = converterManager.findConverters(originalData, ANY_FILE_EXTENSION_FILTER);
        if (converters.length == 1) {
            try {
                return FileViewer.convertToFile(originalData, converters[0]);
            }
            catch (ConversionException e) {
                String format = "A ConversionException occurred when converting the data \"%s\" to a file format.";
                String exceptionMessage = String.format(format, originalData.getMetadata().get("Label"));
                throw new ConvertDataForViewingException(exceptionMessage, e);
            }
        }
        try {
            return FileViewer.convertDataBasedOffUserChosenConverter(originalData, converters, ciShellContext);
        }
        catch (ConversionException conversionException) {
            String exceptionMessage = String.format("A ConversionException occurred when converting the data \"%s\".", originalData.getMetadata().get("Label"));
            throw new ConvertDataForViewingException(exceptionMessage, conversionException);
        }
        catch (UserCanceledDataViewSelectionException e) {
            String format = "A UserCanceledDataViewSelectionException occurred when the user did not choose a converter for the data \"%s\".";
            String exceptionMessage = String.format(format, originalData.getMetadata().get("Label"));
            throw new ConvertDataForViewingException(exceptionMessage, e);
        }
    }

    private static Program selectChosenProgramForFileExtension(String defaultFileExtension, String customFileExtension) throws NoProgramFoundException {
        String chosenFileExtension = null;
        chosenFileExtension = customFileExtension.equals("") ? defaultFileExtension : customFileExtension;
        Program chosenProgram = FileViewer.getProgramForFileExtension(chosenFileExtension);
        if (chosenProgram != null) {
            return chosenProgram;
        }
        Program defaultProgram = FileViewer.getProgramForFileExtension(defaultFileExtension);
        if (defaultProgram != null) {
            return defaultProgram;
        }
        String exceptionMessage = "You do not have a valid viewer for the ." + chosenFileExtension + "file installed.";
        throw new NoProgramFoundException(exceptionMessage);
    }

    private static void executeProgramWithFile(final Program program, final File file) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                program.execute(file.getAbsolutePath());
            }
        });
    }

    private static File convertToFile(Data data, String targetFormat, DataConversionService conversionManager) throws ConversionException {
        if (targetFormat.matches(ANY_FILE_FORMAT_PATTERN)) {
            Converter[] converters = conversionManager.findConverters(data, targetFormat);
            return FileViewer.convertToFile(data, converters[0]);
        }
        String exceptionMessage = "The target format for conversion (\"" + targetFormat + "\") is not valid.";
        throw new ConversionException(exceptionMessage);
    }

    private static File convertToFile(Data data, Converter converter) throws ConversionException {
        Data dataWithCleanedLabelForConversion = FileViewer.cloneDataWithCleanedLabelForConversion(data);
        Data newData = converter.convert(dataWithCleanedLabelForConversion);
        return (File)newData.getData();
    }

    private static File convertDataBasedOffUserChosenConverter(Data originalData, Converter[] converters, CIShellContext ciShellContext) throws ConversionException, UserCanceledDataViewSelectionException {
        DataViewer dataViewer = new DataViewer(originalData, converters, ciShellContext);
        if (dataViewer.selectedConverter != null) {
            return FileViewer.convertToFile(originalData, dataViewer.selectedConverter);
        }
        String exceptionMessage = "The user cancelled the selection of a converter for the data \"" + originalData.getMetadata().get("Label") + "\".";
        throw new UserCanceledDataViewSelectionException(exceptionMessage);
    }

    private static Program getProgramForFileExtension(final String fileExtension) {
        final Program[] programHolder = new Program[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                programHolder[0] = Program.findProgram((String)fileExtension);
            }
        });
        return programHolder[0];
    }

    private static Data cloneDataWithCleanedLabelForConversion(Data originalData) {
        BasicData clonedData = new BasicData(originalData.getData(), originalData.getFormat());
        Dictionary originalMetadata = originalData.getMetadata();
        Dictionary clonedMetadata = clonedData.getMetadata();
        Enumeration keys = originalMetadata.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if ("Label".equals(key)) {
                clonedMetadata.put(key, FileUtilities.replaceInvalidFilenameCharacters((String)((String)originalMetadata.get(key))));
                continue;
            }
            clonedMetadata.put(key, originalMetadata.get(key));
        }
        return clonedData;
    }

    private static final class DataViewer
    implements Runnable {
        public static final String VIEW_DIALOG_TITLE = "View";
        private Shell shellWindow;
        private Converter selectedConverter;
        private Data data;
        private Converter[] converters;
        private CIShellContext ciShellContext;
        private LogService logger;

        public DataViewer(Data data, Converter[] converters, CIShellContext ciShellContext) {
            this(data, converters, ciShellContext, (LogService)ciShellContext.getService(LogService.class.getName()));
        }

        public DataViewer(Data data, Converter[] converters, CIShellContext ciShellContext, LogService logger) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            this.shellWindow = windows[0].getShell();
            this.data = data;
            this.converters = converters;
            this.ciShellContext = ciShellContext;
            this.logger = logger;
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec((Runnable)this);
        }

        @Override
        public void run() {
            ViewDataChooser viewDataChooser = new ViewDataChooser(VIEW_DIALOG_TITLE, this.shellWindow, this.data, this.converters, this.ciShellContext, this.logger);
            viewDataChooser.open();
            this.selectedConverter = viewDataChooser.getSelectedConverter();
        }
    }

    private static class FileWithExtension {
        public final File file;
        public final String fileExtension;

        public FileWithExtension(File file, String fileExtension) {
            this.file = file;
            this.fileExtension = fileExtension;
        }
    }
}

