/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboFieldEditor
extends FieldEditor {
    public static final int UNLIMITED = -1;
    Combo textField;
    private String[] predefinedValues;
    private boolean isValid;
    private String oldValue;
    private int widthInChars = -1;
    private int textLimit = -1;
    private String errorMessage;
    private boolean emptyStringAllowed = true;

    protected ComboFieldEditor() {
    }

    public ComboFieldEditor(String name, String labelText, int width, Composite parent) {
        this.init(name, labelText);
        this.widthInChars = width;
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    public ComboFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, -1, parent);
    }

    protected boolean checkState() {
        String txt;
        boolean result = false;
        if (this.emptyStringAllowed) {
            result = true;
        }
        if (this.textField == null) {
            result = false;
        }
        if ((txt = this.textField.getText()) == null) {
            result = false;
        }
        result = txt.trim().length() > 0 || this.emptyStringAllowed;
        boolean bl = result = result && this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected void doLoad() {
        if (this.textField != null) {
            this.addDefaultOptions();
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.textField.setText(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            this.addDefaultOptions();
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.textField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.textField.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Combo getTextControl() {
        return this.textField;
    }

    public Combo getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Combo(parent, 2052);
            this.textField.setFont(parent.getFont());
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ComboFieldEditor.this.valueChanged();
                }
            });
            this.textField.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ComboFieldEditor.this.valueChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ComboFieldEditor.this.valueChanged();
                }
            });
            this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ComboFieldEditor.this.refreshValidState();
                }

                public void focusLost(FocusEvent e) {
                    ComboFieldEditor.this.valueChanged();
                    ComboFieldEditor.this.clearErrorMessage();
                }
            });
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ComboFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean b) {
        this.emptyStringAllowed = b;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            String newValue = value;
            if (newValue == null) {
                newValue = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(newValue)) {
                this.textField.setText(newValue);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if (!(newValue = this.textField.getText()).equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.textField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != -1) {
            GC gc = new GC((Drawable)this.textField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.textField.setLayoutData((Object)gd);
    }

    public void setPredefinedValues(String[] strings) {
        this.predefinedValues = strings;
    }

    private void addDefaultOptions() {
        if (this.textField != null && this.predefinedValues != null) {
            this.textField.setItems(this.predefinedValues);
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
    }
}

