/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.gui.prefgui.customfields;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleFieldEditor
extends StringFieldEditor {
    public DoubleFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setEmptyStringAllowed(false);
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
            text.setText("" + value);
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
            text.setText("" + value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            Double i = Double.valueOf(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), i.doubleValue());
        }
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.getStringValue());
    }

    public boolean checkState() {
        try {
            Double.parseDouble(this.getStringValue());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

