/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.gui.prefgui.customfields;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FloatFieldEditor
extends StringFieldEditor {
    public FloatFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setEmptyStringAllowed(false);
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            float value = this.getPreferenceStore().getFloat(this.getPreferenceName());
            text.setText("" + value);
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            float value = this.getPreferenceStore().getDefaultFloat(this.getPreferenceName());
            text.setText("" + value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            Float i = Float.valueOf(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), i.floatValue());
        }
    }

    public float getFloatValue() {
        return Float.parseFloat(this.getStringValue());
    }

    public boolean checkState() {
        try {
            Float.parseFloat(this.getStringValue());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

