/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.gui.prefgui.preferencepages;

import java.io.IOException;
import org.cishell.gui.prefgui.customfields.DoubleFieldEditor;
import org.cishell.gui.prefgui.customfields.FloatFieldEditor;
import org.cishell.reference.gui.prefs.swt.CIShellPreferenceStore;
import org.cishell.reference.prefs.admin.PreferenceAD;
import org.cishell.reference.prefs.admin.PreferenceOCD;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.osgi.service.log.LogService;

public class CIShellPreferencePage
extends FieldEditorPreferencePage {
    private PreferenceOCD prefOCD;
    private LogService log;

    public CIShellPreferencePage(LogService log, PreferenceOCD prefOCD, CIShellPreferenceStore prefStore) {
        super(0);
        this.setTitle(prefOCD.getName());
        this.prefOCD = prefOCD;
        this.setPreferenceStore((IPreferenceStore)prefStore);
    }

    protected void createFieldEditors() {
        PreferenceAD[] prefADs = this.prefOCD.getPreferenceAttributeDefinitions(-1);
        int ii = 0;
        while (ii < prefADs.length) {
            Object dField;
            PreferenceAD prefAD = prefADs[ii];
            int attrType = prefAD.getPreferenceType();
            if (attrType == 11) {
                BooleanFieldEditor bField = new BooleanFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)bField);
            } else if (attrType == 3) {
                IntegerFieldEditor iField = new IntegerFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)iField);
            } else if (attrType == 24) {
                String[] optionLabels = prefAD.getOptionLabels();
                String[] optionValues = prefAD.getOptionValues();
                String[][] labelAndValues = new String[optionLabels.length][2];
                int jj = 0;
                while (jj < labelAndValues.length) {
                    labelAndValues[jj][0] = optionLabels[jj];
                    labelAndValues[jj][1] = optionValues[jj];
                    ++jj;
                }
                RadioGroupFieldEditor rgField = new RadioGroupFieldEditor(prefAD.getID(), prefAD.getName(), 1, labelAndValues, this.getFieldEditorParent(), true);
                this.addField((FieldEditor)rgField);
            } else if (attrType == 22) {
                FontFieldEditor foField = new FontFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)foField);
            } else if (attrType == 20) {
                dField = new DirectoryFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                dField.setEmptyStringAllowed(true);
                this.addField((FieldEditor)dField);
            } else if (attrType == 21) {
                FileFieldEditor fiField = new FileFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                fiField.setEmptyStringAllowed(true);
                this.addField((FieldEditor)fiField);
            } else if (attrType == 23) {
                PathEditor pField = new PathEditor(prefAD.getID(), prefAD.getName(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)pField);
            } else if (attrType == 19) {
                StringFieldEditor sField = new StringFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)sField);
            } else if (attrType == 7) {
                dField = new DoubleFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)dField);
            } else if (attrType == 8) {
                FloatFieldEditor fField = new FloatFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)fField);
            } else if (attrType == 25) {
                ColorFieldEditor cField = new ColorFieldEditor(prefAD.getID(), prefAD.getName(), this.getFieldEditorParent());
                this.addField((FieldEditor)cField);
            }
            ++ii;
        }
    }

    public void performApply() {
        super.performApply();
        try {
            if (this.getPreferenceStore() instanceof CIShellPreferenceStore) {
                CIShellPreferenceStore realPrefStore = (CIShellPreferenceStore)this.getPreferenceStore();
                realPrefStore.save();
            }
        }
        catch (ClassCastException classCastException) {
            super.performApply();
        }
        catch (IOException e) {
            this.log.log(2, "Unable to save preferences due to I/O Exception", (Throwable)e);
        }
    }
}

