/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.prefs.swt;

import java.util.Arrays;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;
import org.cishell.gui.prefgui.preferencepages.BlankPreferencePage;
import org.cishell.gui.prefgui.preferencepages.CIShellPreferencePage;
import org.cishell.reference.gui.prefs.swt.CIShellPreferenceStore;
import org.cishell.reference.prefs.admin.PrefAdmin;
import org.cishell.reference.prefs.admin.PrefPage;
import org.cishell.reference.prefs.admin.PrefPageComparator;
import org.cishell.reference.prefs.admin.PreferenceOCD;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.cm.Configuration;
import org.osgi.service.log.LogService;

public class PreferenceGuiAlgorithm
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;
    PrefAdmin prefAdmin;
    LogService log;

    public PreferenceGuiAlgorithm(Data[] data, Dictionary parameters, CIShellContext context, PrefAdmin prefAdmin, LogService log) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.prefAdmin = prefAdmin;
        this.log = log;
    }

    public Data[] execute() {
        PreferenceManager prefManager = new PreferenceManager();
        this.addGlobalPreferences(prefManager);
        this.addLocalPreferences(prefManager);
        this.addParamPreferences(prefManager);
        Shell parentShell = this.getParentShell();
        PreferenceGUIRunnable prefGUIRunnable = new PreferenceGUIRunnable(parentShell, prefManager);
        Thread preferenceGUIThread = new Thread(prefGUIRunnable);
        parentShell.getDisplay().asyncExec((Runnable)preferenceGUIThread);
        return null;
    }

    private void addGlobalPreferences(PreferenceManager prefManager) {
        PrefPage[] globalPrefPages = this.prefAdmin.getGlobalPrefPages();
        BlankPreferencePage globalPrefPageRoot = new BlankPreferencePage(1, "General Preferences", "Contains preferences that change the workbench's functionality.");
        PreferenceNode rootNode = new PreferenceNode("General Preferences Root", (IPreferencePage)globalPrefPageRoot);
        prefManager.addToRoot((IPreferenceNode)rootNode);
        this.addPrefPages(globalPrefPages, rootNode);
    }

    private void addLocalPreferences(PreferenceManager prefManager) {
        PrefPage[] localPrefPages = this.prefAdmin.getLocalPrefPages();
        BlankPreferencePage localPrefPageRoot = new BlankPreferencePage(1, "Algorithm Preferences", "Contains preferences that modify how particular algorithms work.");
        PreferenceNode rootNode = new PreferenceNode("Algorithm Preferences Root", (IPreferencePage)localPrefPageRoot);
        prefManager.addToRoot((IPreferenceNode)rootNode);
        this.addPrefPages(localPrefPages, rootNode);
    }

    private void addParamPreferences(PreferenceManager prefManager) {
        PrefPage[] paramPrefPages = this.prefAdmin.getParamPrefPages();
        BlankPreferencePage paramPrefPageRoot = new BlankPreferencePage(1, "Algorithm Parameter Preferences", "Contains preferences that specify the default values for algorithm menus");
        PreferenceNode rootNode = new PreferenceNode("General Preferences Root", (IPreferencePage)paramPrefPageRoot);
        prefManager.addToRoot((IPreferenceNode)rootNode);
        this.addPrefPages(paramPrefPages, rootNode);
    }

    private Shell getParentShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        IWorkbenchWindow window = windows[0];
        Shell parentShell = window.getShell();
        return parentShell;
    }

    private void addPrefPages(PrefPage[] prefPages, PreferenceNode rootNode) {
        Arrays.sort(prefPages, new PrefPageComparator());
        int ii = 0;
        while (ii < prefPages.length) {
            PreferenceNode prefNode = this.makePreferenceNode(prefPages[ii]);
            rootNode.add((IPreferenceNode)prefNode);
            ++ii;
        }
    }

    private PreferenceNode makePreferenceNode(PrefPage prefPage) {
        PreferenceOCD prefOCD = prefPage.getPrefOCD();
        Configuration prefConf = prefPage.getPrefConf();
        CIShellPreferenceStore prefStore = new CIShellPreferenceStore(this.log, prefOCD, prefConf);
        CIShellPreferencePage guiPrefPage = new CIShellPreferencePage(this.log, prefOCD, prefStore);
        return new PreferenceNode(prefConf.getPid(), (IPreferencePage)guiPrefPage);
    }

    private class PreferenceGUIRunnable
    implements Runnable {
        private Shell parentShell;
        private PreferenceManager prefManager;

        public PreferenceGUIRunnable(Shell parentShell, PreferenceManager prefManager) {
            this.parentShell = parentShell;
            this.prefManager = prefManager;
        }

        @Override
        public void run() {
            PreferenceDialog prefDialog = new PreferenceDialog(this.parentShell, this.prefManager);
            prefDialog.open();
        }
    }
}

