/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.scheduler;

import java.util.Calendar;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.reference.gui.scheduler.Activator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SchedulerTableItem {
    public static final Image CHECKED_IMAGE = Activator.createImage("check.gif");
    public static final Image UNCHECKED_IMAGE = Activator.createImage("uncheck.gif");
    public static final Image ERROR_IMAGE = Activator.createImage("error.gif");
    private String algorithmLabel;
    private Calendar calendar;
    private TableItem tableItem;
    private TableEditor tableEditor;
    private int progressSelection;
    private ProgressBar progressBar;
    private boolean encounteredError;
    private String workBeingDone;
    private boolean cancelRequested;
    private boolean pauseRequested;
    private boolean started;
    private boolean done;
    private boolean isCancellable;
    private boolean isPauseable;
    private boolean isWorkTrackable;
    private AlgorithmProgressMonitor algorithmProgressMonitor;

    public SchedulerTableItem(String algorithmLabel, Calendar calendar, Algorithm algorithm) {
        this.algorithmLabel = algorithmLabel;
        this.calendar = calendar;
        this.encounteredError = false;
        this.cancelRequested = false;
        this.started = false;
        this.done = false;
        this.isCancellable = false;
        this.isPauseable = false;
        this.isWorkTrackable = false;
        if (algorithm instanceof ProgressTrackable) {
            this.algorithmProgressMonitor = new AlgorithmProgressMonitor();
            ((ProgressTrackable)algorithm).setProgressMonitor((ProgressMonitor)this.algorithmProgressMonitor);
        }
    }

    public void requestCancel(boolean request) {
        this.cancelRequested = request;
    }

    public void requestPause(boolean request) {
        this.pauseRequested = request;
    }

    public void initTableEntry(final Table table, final int tblNdx) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                SchedulerTableItem.this.drawTableEntry(table, tblNdx);
            }
        });
    }

    public void finishTableEntry(final Table table) {
        this.done = true;
        if (!this.tableItem.isDisposed()) {
            this.guiRun(new Runnable(){

                @Override
                public void run() {
                    SchedulerTableItem.this.progressBar.dispose();
                    SchedulerTableItem.this.progressBar = new ProgressBar((Composite)table, 0);
                    SchedulerTableItem.this.progressSelection = SchedulerTableItem.this.progressBar.getMaximum();
                    SchedulerTableItem.this.drawTableEntry(table, table.indexOf(SchedulerTableItem.this.tableItem));
                }
            });
        }
    }

    public void moveTableEntry(final Table table, final int tblNdx) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                SchedulerTableItem.this.progressSelection = SchedulerTableItem.this.progressBar.getSelection();
                SchedulerTableItem.this.drawTableEntry(table, tblNdx);
            }
        });
    }

    private void drawTableEntry(final Table table, final int tableIndex) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                if (SchedulerTableItem.this.tableItem != null) {
                    SchedulerTableItem.this.tableItem.dispose();
                }
                SchedulerTableItem.this.tableItem = new TableItem(table, 0, tableIndex);
                if (SchedulerTableItem.this.done) {
                    SchedulerTableItem.this.tableItem.setImage(0, CHECKED_IMAGE);
                } else if (SchedulerTableItem.this.encounteredError) {
                    SchedulerTableItem.this.tableItem.setImage(0, ERROR_IMAGE);
                } else {
                    SchedulerTableItem.this.tableItem.setImage(0, UNCHECKED_IMAGE);
                }
                SchedulerTableItem.this.tableItem.setText(1, SchedulerTableItem.this.algorithmLabel);
                SchedulerTableItem.this.setCalendar();
                if (SchedulerTableItem.this.started) {
                    if (SchedulerTableItem.this.progressBar != null) {
                        SchedulerTableItem.this.progressBar.dispose();
                    }
                    if (SchedulerTableItem.this.isWorkTrackable || SchedulerTableItem.this.done) {
                        SchedulerTableItem.this.progressBar = new ProgressBar((Composite)table, 0);
                        SchedulerTableItem.this.progressBar.setSelection(SchedulerTableItem.this.progressSelection);
                    } else {
                        SchedulerTableItem.this.progressBar = new ProgressBar((Composite)table, 2);
                    }
                } else {
                    SchedulerTableItem.this.progressBar = new ProgressBar((Composite)table, 0);
                }
                SchedulerTableItem.this.tableEditor = new TableEditor(table);
                ((SchedulerTableItem)SchedulerTableItem.this).tableEditor.grabHorizontal = true;
                ((SchedulerTableItem)SchedulerTableItem.this).tableEditor.grabVertical = true;
                SchedulerTableItem.this.tableEditor.setEditor((Control)SchedulerTableItem.this.progressBar, SchedulerTableItem.this.tableItem, 4);
            }
        });
    }

    private void setCalendar() {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                String date = SchedulerTableItem.this.getDateString(SchedulerTableItem.this.calendar);
                String time = SchedulerTableItem.this.getTimeString(SchedulerTableItem.this.calendar);
                SchedulerTableItem.this.tableItem.setText(2, date);
                SchedulerTableItem.this.tableItem.setText(3, time);
            }
        });
    }

    public void algorithmStarted(Table table) {
        this.done = false;
        this.started = true;
        this.drawTableEntry(table, table.indexOf(this.tableItem));
    }

    public void reschedule(Calendar calendar) {
        this.calendar = calendar;
        this.setCalendar();
    }

    public void errorTableEntry(Table table) {
        this.encounteredError = true;
        this.drawTableEntry(table, table.indexOf(this.tableItem));
    }

    public void refresh() {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                if (!SchedulerTableItem.this.progressBar.isDisposed()) {
                    SchedulerTableItem.this.progressBar.setSelection(SchedulerTableItem.this.progressSelection);
                    ((SchedulerTableItem)SchedulerTableItem.this).tableEditor.grabHorizontal = true;
                    ((SchedulerTableItem)SchedulerTableItem.this).tableEditor.grabVertical = true;
                    SchedulerTableItem.this.tableEditor.setEditor((Control)SchedulerTableItem.this.progressBar, SchedulerTableItem.this.tableItem, 4);
                }
            }
        });
    }

    public void remove() {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                SchedulerTableItem.this.progressBar.dispose();
                SchedulerTableItem.this.tableItem.dispose();
            }
        });
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    private String getDateString(Calendar time) {
        String month = String.valueOf(time.get(2) + 1);
        String day = String.valueOf(time.get(5));
        String year = String.valueOf(time.get(1));
        if (month.length() == 1) {
            month = "0" + month;
        }
        if (day.length() == 1) {
            day = "0" + day;
        }
        return String.valueOf(month) + "/" + day + "/" + year;
    }

    private String getTimeString(Calendar time) {
        String minute = String.valueOf(time.get(12));
        String hour = String.valueOf(time.get(10));
        String second = String.valueOf(time.get(13));
        int ampm = time.get(9);
        String amPmString = "PM";
        if (ampm == 0) {
            amPmString = "AM";
        }
        if (minute.length() == 1) {
            minute = "0" + minute;
        }
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (second.length() == 1) {
            second = "0" + second;
        }
        return String.valueOf(hour) + ":" + minute + ":" + second + " " + amPmString;
    }

    private void guiRun(Runnable run) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            run.run();
        } else {
            Display.getDefault().syncExec(run);
        }
    }

    public boolean isCancellable() {
        if (this.done) {
            return false;
        }
        return this.isCancellable;
    }

    public boolean isPausable() {
        if (this.done) {
            return false;
        }
        return this.isPauseable;
    }

    public boolean isWorkTrackable() {
        return this.isWorkTrackable();
    }

    public boolean isPaused() {
        return this.algorithmProgressMonitor.isPaused() && !this.done;
    }

    public boolean isRunning() {
        return !this.cancelRequested;
    }

    public boolean isDone() {
        return this.done;
    }

    private class AlgorithmProgressMonitor
    implements ProgressMonitor {
        private double totalWorkUnits;

        private AlgorithmProgressMonitor() {
        }

        public void describeWork(String currentWork) {
            SchedulerTableItem.this.workBeingDone = currentWork;
        }

        public void done() {
            SchedulerTableItem.this.done = true;
        }

        public boolean isCanceled() {
            return SchedulerTableItem.this.cancelRequested;
        }

        public boolean isPaused() {
            return SchedulerTableItem.this.pauseRequested;
        }

        public void setCanceled(boolean value) {
            SchedulerTableItem.this.cancelRequested = value;
        }

        public void setPaused(boolean value) {
            SchedulerTableItem.this.pauseRequested = value;
        }

        public void start(int capabilities, int totalWorkUnits) {
            this.start(capabilities, this.totalWorkUnits);
        }

        public void start(int capabilities, double totalWorkUnits) {
            if ((capabilities & 4) > 0) {
                SchedulerTableItem.this.isCancellable = true;
            }
            if ((capabilities & 8) > 0) {
                SchedulerTableItem.this.isPauseable = true;
            }
            if ((capabilities & 2) > 0) {
                SchedulerTableItem.this.refresh();
                SchedulerTableItem.this.isWorkTrackable = true;
                SchedulerTableItem.this.guiRun(new Runnable(){

                    @Override
                    public void run() {
                        Table table = (Table)SchedulerTableItem.this.progressBar.getParent();
                        SchedulerTableItem.this.progressBar.dispose();
                        SchedulerTableItem.this.progressBar = new ProgressBar((Composite)table, 0);
                        SchedulerTableItem.this.progressBar.setSelection(SchedulerTableItem.this.progressBar.getMinimum());
                        SchedulerTableItem.this.tableEditor = new TableEditor(table);
                        ((SchedulerTableItem)((AlgorithmProgressMonitor)AlgorithmProgressMonitor.this).SchedulerTableItem.this).tableEditor.grabHorizontal = true;
                        ((SchedulerTableItem)((AlgorithmProgressMonitor)AlgorithmProgressMonitor.this).SchedulerTableItem.this).tableEditor.grabVertical = true;
                        SchedulerTableItem.this.tableEditor.setEditor((Control)SchedulerTableItem.this.progressBar, SchedulerTableItem.this.tableItem, 4);
                    }
                });
            }
            this.totalWorkUnits = totalWorkUnits;
        }

        public void worked(int work) {
            this.worked((double)work);
        }

        public void worked(final double work) {
            SchedulerTableItem.this.guiRun(new Runnable(){

                @Override
                public void run() {
                    if (!SchedulerTableItem.this.progressBar.isDisposed()) {
                        SchedulerTableItem.this.progressSelection = (int)((double)SchedulerTableItem.this.progressBar.getMaximum() * (work / AlgorithmProgressMonitor.this.totalWorkUnits));
                    }
                }
            });
            SchedulerTableItem.this.refresh();
        }
    }
}

