/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.scheduler;

import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cishell.app.service.scheduler.SchedulerListener;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.scheduler.Activator;
import org.cishell.reference.gui.scheduler.SchedulerContentModel;
import org.cishell.reference.gui.scheduler.SchedulerTableItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.ServiceReference;

public class SchedulerView
extends ViewPart
implements SchedulerListener {
    private static SchedulerView schedulerView;
    public static final String ID_VIEW = "org.cishell.reference.gui.scheduler.SchedulerView";
    private static Image upImage;
    private static Image downImage;
    private static Image playImage;
    private static Image pauseImage;
    private SchedulerContentModel schedulerContentModel = SchedulerContentModel.getInstance();
    private Map algorithmToGuiItemMap;
    private Map tableItemToAlgorithmMap;
    private static Composite parent;
    private Button removeButton;
    private Button removeAutomatically;
    private Button up;
    private Button down;
    private Menu menu;
    private Button pauseStateButton;
    private Button playStateButton;
    private Table table;
    private boolean autoRemove;
    public static final int RESUME_INDEX = 0;
    public static final int PAUSE_INDEX = 1;
    public static final int CANCEL_INDEX = 2;
    private PauseListener pauseListener;
    private CancelListener cancelListener;
    private StartListener startListener;
    public static final int COMPLETED_COLUMN = 0;
    public static final int ALGORITHM_COLUMN = 1;
    public static final int DATE_COLUMN = 2;
    public static final int TIME_COLUMN = 3;
    public static final int PERCENT_COLUMN = 4;

    static {
        upImage = Activator.createImage("up.gif");
        downImage = Activator.createImage("down.gif");
        playImage = Activator.createImage("play.png");
        pauseImage = Activator.createImage("pause.png");
    }

    public SchedulerView() {
        this.schedulerContentModel.register(this);
        this.algorithmToGuiItemMap = (Map)this.schedulerContentModel.getPersistedObject(((Object)((Object)this)).getClass().getName());
        this.algorithmToGuiItemMap = this.algorithmToGuiItemMap == null ? Collections.synchronizedMap(new Hashtable()) : Collections.synchronizedMap(this.algorithmToGuiItemMap);
        schedulerView = this;
    }

    public static SchedulerView getDefault() {
        return schedulerView;
    }

    public void createPartControl(Composite parent) {
        SchedulerView.parent = parent;
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        control.setLayout((Layout)layout);
        this.removeButton = new Button(control, 8);
        this.removeButton.setText("Remove From List");
        this.removeButton.setEnabled(true);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulerView.this.removeSelection();
                SchedulerView.this.refresh();
            }
        });
        this.removeAutomatically = new Button(control, 32);
        this.removeAutomatically.setText("Remove completed automatically");
        this.removeAutomatically.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchedulerView.this.autoRemove = SchedulerView.this.removeAutomatically.getSelection();
            }
        });
        Button removeAllCompleted = new Button(control, 8);
        removeAllCompleted.setText("Remove all completed");
        removeAllCompleted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulerView.this.removeCompleted();
                SchedulerView.this.refresh();
            }
        });
        this.playStateButton = new Button(control, 8);
        this.playStateButton.setImage(playImage);
        this.playStateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulerView.this.schedulerContentModel.schedulerRunStateChanged(true);
            }
        });
        this.pauseStateButton = new Button(control, 8);
        this.pauseStateButton.setImage(pauseImage);
        this.pauseStateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulerView.this.schedulerContentModel.schedulerRunStateChanged(false);
            }
        });
        if (this.schedulerContentModel.isRunning()) {
            this.playStateButton.setEnabled(false);
        } else {
            this.pauseStateButton.setEnabled(false);
        }
        GridData removeAllCompletedData = new GridData();
        removeAllCompletedData.horizontalAlignment = 131072;
        removeAllCompleted.setLayoutData((Object)removeAllCompletedData);
        Composite tableComposite = new Composite(control, 0);
        GridLayout tableCompositeLayout = new GridLayout();
        tableCompositeLayout.numColumns = 2;
        tableComposite.setLayout((Layout)tableCompositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.horizontalSpan = 4;
        tableComposite.setLayoutData((Object)compositeData);
        Composite upAndDown = new Composite(tableComposite, 0);
        GridLayout upAndDownLayout = new GridLayout();
        upAndDownLayout.numColumns = 1;
        upAndDown.setLayout((Layout)upAndDownLayout);
        this.up = new Button(upAndDown, 8);
        this.up.setToolTipText("Moves the selected item up in the queue if possible. Only queued items can be moved without rescheduling.");
        this.up.setEnabled(false);
        this.up.setImage(upImage);
        this.up.addSelectionListener((SelectionListener)new UpButtonListener());
        this.down = new Button(upAndDown, 8);
        this.down.setToolTipText("Moves the selected item down in the queue if possible. Only queued items can be moved without rescheduling.");
        this.down.setEnabled(false);
        this.down.setImage(downImage);
        this.down.addSelectionListener((SelectionListener)new DownButtonListener());
        this.createTable(tableComposite);
        this.createTableEntries(this.table);
        this.table.addSelectionListener((SelectionListener)new TableListener());
        this.menu = new Menu((Control)this.table);
        this.menu.setVisible(false);
        MenuItem startItem = new MenuItem(this.menu, 8);
        startItem.setText("resume");
        this.startListener = new StartListener();
        startItem.addListener(13, (Listener)this.startListener);
        MenuItem pauseItem = new MenuItem(this.menu, 8);
        pauseItem.setText("pause");
        this.pauseListener = new PauseListener();
        pauseItem.addListener(13, (Listener)this.pauseListener);
        MenuItem cancelItem = new MenuItem(this.menu, 8);
        cancelItem.setText("cancel");
        this.cancelListener = new CancelListener();
        cancelItem.addListener(13, (Listener)this.cancelListener);
        this.table.setMenu(this.menu);
        GridData gridData = new GridData(1808);
        this.table.setLayoutData((Object)gridData);
    }

    public void setFocus() {
    }

    public void algorithmError(final Algorithm algorithm, Throwable error) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                SchedulerTableItem schedulerTableItem = (SchedulerTableItem)SchedulerView.this.algorithmToGuiItemMap.get(algorithm);
                if (schedulerTableItem != null) {
                    schedulerTableItem.errorTableEntry(SchedulerView.this.table);
                }
            }
        });
        this.refresh();
    }

    public void algorithmFinished(Algorithm algorithm, Data[] createdData) {
        SchedulerTableItem schedulerTableItem = (SchedulerTableItem)this.algorithmToGuiItemMap.get(algorithm);
        if (schedulerTableItem != null) {
            schedulerTableItem.finishTableEntry(this.table);
            this.tableItemToAlgorithmMap.put(schedulerTableItem.getTableItem(), algorithm);
            if (this.autoRemove) {
                schedulerTableItem.remove();
                TableItem tableItem = schedulerTableItem.getTableItem();
                this.tableItemToAlgorithmMap.remove(tableItem);
                this.algorithmToGuiItemMap.remove(algorithm);
            }
        }
        this.refresh();
    }

    public void algorithmRescheduled(Algorithm algorithm, Calendar time) {
        SchedulerTableItem schedulerTableItem = (SchedulerTableItem)this.algorithmToGuiItemMap.get(algorithm);
        if (schedulerTableItem != null) {
            schedulerTableItem.reschedule(time);
        }
        this.refresh();
    }

    public void algorithmScheduled(final Algorithm algorithm, final Calendar cal) {
        final Table table = this.table;
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                ServiceReference serviceReference = Activator.getSchedulerService().getServiceReference(algorithm);
                String algorithmLabel = "";
                if (serviceReference != null) {
                    algorithmLabel = (String)serviceReference.getProperty("label");
                }
                SchedulerTableItem schedulerTableItem = new SchedulerTableItem(algorithmLabel, cal, algorithm);
                schedulerTableItem.initTableEntry(table, 0);
                SchedulerView.this.algorithmToGuiItemMap.put(algorithm, schedulerTableItem);
                TableItem tableItem = schedulerTableItem.getTableItem();
                SchedulerView.this.tableItemToAlgorithmMap.put(tableItem, algorithm);
            }
        });
        this.refresh();
    }

    public void algorithmStarted(final Algorithm algorithm) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                SchedulerTableItem schedulerTableItem = (SchedulerTableItem)SchedulerView.this.algorithmToGuiItemMap.get(algorithm);
                schedulerTableItem.algorithmStarted(SchedulerView.this.table);
                TableItem tableItem = schedulerTableItem.getTableItem();
                SchedulerView.this.tableItemToAlgorithmMap.put(tableItem, algorithm);
            }
        });
        this.refresh();
    }

    public void algorithmUnscheduled(Algorithm algorithm) {
        SchedulerTableItem schedulerTableItem = (SchedulerTableItem)this.algorithmToGuiItemMap.get(algorithm);
        schedulerTableItem.remove();
        this.refresh();
    }

    public void schedulerCleared() {
        for (SchedulerTableItem schedulerTableItem : this.algorithmToGuiItemMap.values()) {
            schedulerTableItem.remove();
        }
        this.algorithmToGuiItemMap.clear();
        this.tableItemToAlgorithmMap.clear();
        this.refresh();
    }

    public void schedulerRunStateChanged(boolean isRunning) {
        if (isRunning) {
            this.pauseStateButton.setEnabled(true);
            this.playStateButton.setEnabled(false);
        } else {
            this.playStateButton.setEnabled(true);
            this.pauseStateButton.setEnabled(false);
        }
        this.refresh();
    }

    private void createTableEntries(Table table) {
        Set keys = this.algorithmToGuiItemMap.keySet();
        this.tableItemToAlgorithmMap = Collections.synchronizedMap(new Hashtable());
        for (Algorithm algorithm : keys) {
            SchedulerTableItem schedulerTableItem = (SchedulerTableItem)this.algorithmToGuiItemMap.get(algorithm);
            schedulerTableItem.initTableEntry(table, 0);
            TableItem tableItem = schedulerTableItem.getTableItem();
            this.tableItemToAlgorithmMap.put(tableItem, algorithm);
        }
    }

    private void createTable(Composite parent) {
        int style = 68354;
        this.table = new Table(parent, style);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0x1000000, 0);
        column.setText("!");
        column.setWidth(20);
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Algorithm Name");
        column.setWidth(150);
        column = new TableColumn(this.table, 16384, 2);
        column.setText("Date");
        column.setWidth(90);
        column = new TableColumn(this.table, 16384, 3);
        column.setText("Time");
        column.setWidth(90);
        column = new TableColumn(this.table, 0x1000000, 4);
        column.setText("% Complete");
        column.setWidth(120);
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    SchedulerView.this.removeSelection();
                    SchedulerView.this.refresh();
                }
            }
        });
        ItemDragListener dragListener = new ItemDragListener();
        this.table.addMouseMoveListener((MouseMoveListener)dragListener);
        this.table.addMouseListener((MouseListener)dragListener);
    }

    private void removeSelection() {
        TableItem[] tableItems = this.table.getSelection();
        int i = 0;
        while (i < tableItems.length) {
            for (Algorithm algorithm : this.algorithmToGuiItemMap.keySet()) {
                SchedulerTableItem schedulerTableItem = (SchedulerTableItem)this.algorithmToGuiItemMap.get(algorithm);
                if (!tableItems[i].equals(schedulerTableItem.getTableItem())) continue;
                if (this.algorithmIsProgressTrackable(algorithm)) {
                    ProgressMonitor monitor = ((ProgressTrackable)algorithm).getProgressMonitor();
                    monitor.setCanceled(true);
                }
                schedulerTableItem.remove();
                this.algorithmToGuiItemMap.remove(algorithm);
                break;
            }
            ++i;
        }
    }

    private void removeCompleted() {
        Iterator i = this.algorithmToGuiItemMap.values().iterator();
        while (i.hasNext()) {
            SchedulerTableItem schedulerTableItem = (SchedulerTableItem)i.next();
            if (!schedulerTableItem.isDone()) continue;
            i.remove();
            schedulerTableItem.remove();
        }
    }

    private void refresh() {
        Iterator<Object> i = this.tableItemToAlgorithmMap.keySet().iterator();
        while (i.hasNext()) {
            TableItem tableItem = (TableItem)i.next();
            if (!tableItem.isDisposed()) continue;
            i.remove();
        }
        for (SchedulerTableItem schedulerTableItem : this.algorithmToGuiItemMap.values()) {
            schedulerTableItem.refresh();
        }
        this.refreshUpAndDownButtons();
    }

    private boolean algorithmIsProgressTrackable(Algorithm algorithm) {
        ProgressMonitor monitor;
        return algorithm != null && (monitor = ((ProgressTrackable)algorithm).getProgressMonitor()) != null;
    }

    private void setEnabledMenuItems(Algorithm algorithm) {
        SchedulerTableItem schedulerTableItem = (SchedulerTableItem)this.algorithmToGuiItemMap.get(algorithm);
        int i = 0;
        while (i < this.menu.getItemCount()) {
            MenuItem menuItem = this.menu.getItem(i);
            menuItem.setEnabled(false);
            ++i;
        }
        if (schedulerTableItem.isRunning() && schedulerTableItem.isCancellable()) {
            MenuItem menuItem = this.menu.getItem(2);
            menuItem.setEnabled(true);
        }
        if (schedulerTableItem.isPausable()) {
            if (schedulerTableItem.isPaused()) {
                MenuItem menuItem = this.menu.getItem(0);
                menuItem.setEnabled(true);
            } else {
                MenuItem menuItem = this.menu.getItem(1);
                menuItem.setEnabled(true);
            }
        }
    }

    private void moveTableItems(int ndxToMove, int destNdx) {
        TableItem item = this.table.getItem(ndxToMove);
        if (item != null) {
            Algorithm algorithm = (Algorithm)this.tableItemToAlgorithmMap.get(item);
            this.tableItemToAlgorithmMap.remove(item);
            SchedulerTableItem schedulerTableItem = (SchedulerTableItem)this.algorithmToGuiItemMap.get(algorithm);
            schedulerTableItem.moveTableEntry(this.table, destNdx);
            this.table.setSelection(destNdx);
            TableItem tableItem = schedulerTableItem.getTableItem();
            this.tableItemToAlgorithmMap.put(tableItem, algorithm);
            this.refresh();
        }
    }

    private void refreshUpAndDownButtons() {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                if (SchedulerView.this.table.getItemCount() > 1 && SchedulerView.this.table.getSelectionCount() == 1) {
                    if (SchedulerView.this.table.getSelectionIndex() > 0) {
                        SchedulerView.this.up.setEnabled(true);
                    } else {
                        SchedulerView.this.up.setEnabled(false);
                    }
                    if (SchedulerView.this.table.getSelectionIndex() < SchedulerView.this.table.getItemCount() - 1) {
                        SchedulerView.this.down.setEnabled(true);
                    } else {
                        SchedulerView.this.down.setEnabled(false);
                    }
                } else {
                    SchedulerView.this.up.setEnabled(false);
                    SchedulerView.this.down.setEnabled(false);
                }
            }
        });
    }

    private void guiRun(Runnable run) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            run.run();
        } else {
            Display.getDefault().syncExec(run);
        }
    }

    public void dispose() {
        this.schedulerContentModel.persistObject(((Object)((Object)this)).getClass().getName(), this.algorithmToGuiItemMap);
        this.schedulerContentModel.deregister(this);
    }

    private class CancelListener
    implements Listener {
        private CancelListener() {
        }

        public void handleEvent(Event event) {
            ProgressMonitor monitor;
            Algorithm algorithm;
            TableItem item = SchedulerView.this.table.getItem(SchedulerView.this.table.getSelectionIndex());
            if (item != null && (algorithm = (Algorithm)SchedulerView.this.tableItemToAlgorithmMap.get(item)) instanceof ProgressTrackable && (monitor = ((ProgressTrackable)algorithm).getProgressMonitor()) != null) {
                monitor.setCanceled(true);
                SchedulerView.this.setEnabledMenuItems(algorithm);
            }
        }
    }

    private class DownButtonListener
    extends SelectionAdapter {
        private DownButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem item;
            int tblNdx = SchedulerView.this.table.getSelectionIndex();
            if (tblNdx != -1 && (item = SchedulerView.this.table.getItem(tblNdx)) != null && tblNdx < SchedulerView.this.table.getItemCount() - 1) {
                SchedulerView.this.moveTableItems(tblNdx, tblNdx + 1);
            }
        }
    }

    private class ItemDragListener
    extends MouseAdapter
    implements MouseMoveListener {
        private boolean down = false;
        private Algorithm movingAlgorithm;
        private int movingIndex;
        private int currentIndex;

        private ItemDragListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (this.down && this.movingAlgorithm != null) {
                SchedulerTableItem schedulerTableItem = (SchedulerTableItem)SchedulerView.this.algorithmToGuiItemMap.get(this.movingAlgorithm);
                TableItem movingTableItem = schedulerTableItem.getTableItem();
                TableItem currentItem = SchedulerView.this.table.getItem(new Point(e.x, e.y));
                if (currentItem == null || movingTableItem.equals(currentItem)) {
                    return;
                }
                this.movingIndex = SchedulerView.this.table.indexOf(movingTableItem);
                this.currentIndex = SchedulerView.this.table.indexOf(currentItem);
                SchedulerView.this.moveTableItems(this.movingIndex, this.currentIndex);
            }
        }

        public void mouseDown(MouseEvent e) {
            TableItem item = SchedulerView.this.table.getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            if (e.button == 1) {
                this.down = true;
                this.movingAlgorithm = (Algorithm)SchedulerView.this.tableItemToAlgorithmMap.get(item);
            }
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1) {
                this.down = false;
                this.movingAlgorithm = null;
                Cursor cursor = new Cursor((Device)parent.getDisplay(), 0);
                SchedulerView.this.table.setCursor(cursor);
            }
        }
    }

    private class PauseListener
    implements Listener {
        private PauseListener() {
        }

        public void handleEvent(Event event) {
            ProgressMonitor monitor;
            Algorithm algorithm;
            TableItem item = SchedulerView.this.table.getItem(SchedulerView.this.table.getSelectionIndex());
            if (item != null && (algorithm = (Algorithm)SchedulerView.this.tableItemToAlgorithmMap.get(item)) instanceof ProgressTrackable && (monitor = ((ProgressTrackable)algorithm).getProgressMonitor()) != null) {
                monitor.setPaused(true);
                SchedulerView.this.setEnabledMenuItems(algorithm);
            }
        }
    }

    private class StartListener
    implements Listener {
        private StartListener() {
        }

        public void handleEvent(Event event) {
            ProgressMonitor monitor;
            Algorithm algorithm;
            TableItem item = SchedulerView.this.table.getItem(SchedulerView.this.table.getSelectionIndex());
            if (item != null && (algorithm = (Algorithm)SchedulerView.this.tableItemToAlgorithmMap.get(item)) instanceof ProgressTrackable && (monitor = ((ProgressTrackable)algorithm).getProgressMonitor()) != null) {
                monitor.setPaused(false);
                SchedulerView.this.setEnabledMenuItems(algorithm);
            }
        }
    }

    private class TableListener
    extends SelectionAdapter {
        private TableListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] items = SchedulerView.this.table.getSelection();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                Algorithm algorithm = (Algorithm)SchedulerView.this.tableItemToAlgorithmMap.get(item);
                if (algorithm != null) {
                    if (SchedulerView.this.algorithmIsProgressTrackable(algorithm)) {
                        SchedulerView.this.removeButton.setEnabled(true);
                    } else {
                        SchedulerTableItem schedulerTableItem = (SchedulerTableItem)SchedulerView.this.algorithmToGuiItemMap.get(algorithm);
                        if (schedulerTableItem.isDone()) {
                            SchedulerView.this.removeButton.setEnabled(true);
                        } else {
                            SchedulerView.this.removeButton.setEnabled(false);
                        }
                    }
                    SchedulerView.this.setEnabledMenuItems(algorithm);
                }
                ++i;
            }
            SchedulerView.this.refresh();
        }
    }

    private class UpButtonListener
    extends SelectionAdapter {
        private UpButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int tblNdx = SchedulerView.this.table.getSelectionIndex();
            if (tblNdx != -1) {
                SchedulerView.this.moveTableItems(tblNdx, tblNdx - 1);
            }
        }
    }
}

