/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.controller;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JFileChooser;
import org.cishell.reference.gui.workflow.controller.WorkflowManager;
import org.cishell.reference.gui.workflow.controller.WorkflowSaver;
import org.cishell.reference.gui.workflow.model.AlgorithmWorkflowItem;
import org.cishell.reference.gui.workflow.model.NormalWorkflow;
import org.cishell.reference.gui.workflow.model.Workflow;
import org.cishell.reference.gui.workflow.model.WorkflowItem;
import org.cishell.reference.gui.workflow.views.WorkflowView;
import org.eclipse.swt.widgets.Display;

public class WorkflowMaker {
    public void save(Workflow wf) {
        this.write(wf);
    }

    public synchronized void load() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JFileChooser fileChooser = new JFileChooser();
                File currentDirectory = null;
                fileChooser.setFileSelectionMode(0);
                fileChooser.setCurrentDirectory(currentDirectory);
                fileChooser.showOpenDialog(null);
                File file = fileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        FileReader freader = new FileReader(file);
                        BufferedReader in = new BufferedReader(freader);
                        XStream reader = new XStream((HierarchicalStreamDriver)new StaxDriver());
                        reader.setClassLoader(WorkflowSaver.class.getClassLoader());
                        WorkflowSaver saver = (WorkflowSaver)reader.fromXML((Reader)in);
                        WorkflowManager mgr = WorkflowManager.getInstance();
                        ArrayList<Workflow> list = new ArrayList<Workflow>();
                        Workflow wf = saver.getCurrentWorkflow();
                        list.add(wf);
                        for (Map.Entry<Long, WorkflowItem> item : ((NormalWorkflow)wf).getMap().entrySet()) {
                            ((AlgorithmWorkflowItem)item.getValue()).setWorkflow(wf);
                        }
                        Long id = mgr.getUniqueInternalId();
                        wf.setInternalId(id);
                        mgr.addWorkflow(id, wf);
                        final ArrayList wfList = new ArrayList(list);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                for (Workflow wf : wfList) {
                                    WorkflowView.getDefault().addWorflowtoUI(wf);
                                }
                            }
                        });
                        return;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    public void write(final Workflow wf) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                XStream writer = new XStream((HierarchicalStreamDriver)new StaxDriver());
                writer.autodetectAnnotations(true);
                String xml = writer.toXML((Object)new WorkflowSaver(wf));
                File currentDirectory = null;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(0);
                fileChooser.setCurrentDirectory(currentDirectory);
                fileChooser.showSaveDialog(null);
                File file = fileChooser.getSelectedFile();
                String filePath = file.getPath();
                if (!filePath.toLowerCase().endsWith(".xml")) {
                    file = new File(String.valueOf(filePath) + ".xml");
                }
                if (file != null) {
                    try {
                        FileWriter fstream = new FileWriter(file);
                        BufferedWriter out = new BufferedWriter(fstream);
                        out.write(xml);
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }
}

