/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.controller;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.LinkedHashMap;
import org.cishell.app.service.datamanager.DataManagerService;
import org.cishell.reference.gui.workflow.Activator;
import org.cishell.reference.gui.workflow.model.NormalWorkflow;
import org.cishell.reference.gui.workflow.model.Workflow;
import org.osgi.framework.BundleContext;

public class WorkflowManager {
    @XStreamOmitField
    private static WorkflowManager manager = null;
    private LinkedHashMap<Long, Workflow> map = new LinkedHashMap();
    private Workflow currentWorkflow;
    private Long lastCreatedID = new Long(1L);
    private static BundleContext bundleContext;

    private WorkflowManager() {
        bundleContext = Activator.getContext();
    }

    public static WorkflowManager getInstance() {
        if (manager == null) {
            manager = new WorkflowManager();
        }
        return manager;
    }

    public void addWorkflow(Long id, Workflow wf) {
        this.map.put(id, wf);
    }

    public Workflow createWorkflow(String name, String type) {
        Long newID = this.getUniqueInternalId();
        if (type == "NormalWorkflow") {
            this.currentWorkflow = new NormalWorkflow(String.valueOf(name) + newID, newID);
            this.map.put(newID, this.currentWorkflow);
        }
        return this.currentWorkflow;
    }

    public boolean runWorkflow() {
        DataManagerService dataManager = (DataManagerService)bundleContext.getService(bundleContext.getServiceReference(DataManagerService.class.getName()));
        dataManager.getSelectedData();
        return true;
    }

    public void removeWorkflow(Workflow workflow) {
        this.map.remove(workflow.getInternalId());
    }

    public Long getUniqueInternalId() {
        while (this.map.containsKey(this.lastCreatedID)) {
            this.lastCreatedID = this.lastCreatedID + 1L;
        }
        return this.lastCreatedID;
    }

    public LinkedHashMap<Long, Workflow> getMap() {
        return this.map;
    }

    public void setMap(LinkedHashMap<Long, Workflow> map) {
        this.map = map;
    }

    public Workflow getCurrentWorkflow() {
        return this.currentWorkflow;
    }

    public void setCurrentWorkflow(Workflow currentWorkflow) {
        this.currentWorkflow = currentWorkflow;
    }
}

