/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.model;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationCanceledException;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.workflow.Activator;
import org.cishell.reference.gui.workflow.model.Workflow;
import org.cishell.reference.gui.workflow.model.WorkflowItem;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;
import org.cishell.service.conversion.DataConversionService;
import org.cishell.service.guibuilder.GUIBuilderService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class AlgorithmWorkflowItem
implements WorkflowItem {
    private String name;
    private Long internalId;
    @XStreamOmitField
    private ServiceReference serviceReference;
    private Dictionary<String, Object> parameters;
    private Dictionary<String, String> nameToId;
    @XStreamOmitField
    private Data[] inputData;
    @XStreamOmitField
    protected Converter[][] converters;
    @XStreamOmitField
    private Workflow workflow;
    private String pid;

    public AlgorithmWorkflowItem(String name, Long id, String pid) {
        this.name = name;
        this.internalId = id;
        this.nameToId = new Hashtable<String, String>();
        this.pid = pid;
    }

    @Override
    public String getType() {
        return "AlgorithmItem";
    }

    public void add(String name, String id) {
        this.nameToId.put(name, id);
    }

    public Dictionary<String, String> getNameToId() {
        return this.nameToId;
    }

    public void setNameToId(Dictionary<String, String> nameToId) {
        this.nameToId = nameToId;
    }

    public void setInternalId(Long internalId) {
        this.internalId = internalId;
    }

    public void addParameter(String name, Object obj) {
        String id = this.nameToId.get(name);
        this.parameters.put(id, obj);
    }

    public Object getParameterValue(String name) {
        String id = this.nameToId.get(name);
        return this.parameters.get(id);
    }

    @Override
    public Object[] run() {
        Enumeration<String> e = this.parameters.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            this.parameters.get(key);
        }
        AlgorithmFactory factory = (AlgorithmFactory)Activator.getContext().getService(this.serviceReference);
        Algorithm algo = factory.createAlgorithm(this.inputData, this.parameters, Activator.getCiShellContext());
        if (algo instanceof ProgressTrackable) {
            ProgressTrackable pt = (ProgressTrackable)algo;
            pt.setProgressMonitor((ProgressMonitor)new AlgorithmProgressMonitor());
        }
        try {
            Object[] data = algo.execute();
            return data;
        }
        catch (AlgorithmExecutionException e2) {
            String logMessage = String.format("The algorithm \"%s\" failed to execute", this.name, e2.getMessage());
            this.log(2, logMessage, e2);
            return null;
        }
        catch (AlgorithmCreationCanceledException e3) {
            String logMessage = String.format("The algorithm \"%s\" was canceled by the user.", this.name, e3.getMessage());
            this.log(2, logMessage, e3);
            return null;
        }
        catch (AlgorithmCreationFailedException e4) {
            String format = "An error occurred when creating algorithm \"%s\".  (Reason: %s)";
            String errorMessage = String.format(format, this.name, e4.getMessage());
            GUIBuilderService builder = (GUIBuilderService)Activator.getCiShellContext().getService(GUIBuilderService.class.getName());
            builder.showError("Error!", errorMessage, (Throwable)e4);
            this.log(1, errorMessage, e4);
            return null;
        }
        catch (RuntimeException e5) {
            GUIBuilderService builder = (GUIBuilderService)Activator.getCiShellContext().getService(GUIBuilderService.class.getName());
            String errorMessage = String.format("An unxpected error occurred while executing the algorithm \"%s\".", e5.getMessage());
            builder.showError("Error!", errorMessage, (Throwable)e5);
            return null;
        }
    }

    public void dataSelected(Data[] selectedData) {
        String inDataString = (String)this.serviceReference.getProperty("in_data");
        String[] inData = this.separateInData(inDataString);
        if (inData.length == 1 && inData[0].equalsIgnoreCase("null")) {
            this.inputData = new Data[0];
        } else if (selectedData == null) {
            this.inputData = null;
        } else {
            DataConversionService converter = (DataConversionService)Activator.getCiShellContext().getService(DataConversionService.class.getName());
            ArrayList<Data> dataSet = new ArrayList<Data>(Arrays.asList(selectedData));
            this.inputData = new Data[inData.length];
            this.converters = new Converter[inData.length][];
            int ii = 0;
            while (ii < inData.length) {
                int jj = 0;
                while (jj < dataSet.size()) {
                    Data datum = (Data)dataSet.get(jj);
                    if (datum != null) {
                        if (this.isAssignableFrom(inData[ii], datum)) {
                            dataSet.remove(jj);
                            this.inputData[ii] = datum;
                            this.converters[ii] = null;
                        } else {
                            Converter[] conversion = converter.findConverters(datum, inData[ii]);
                            if (conversion.length > 0) {
                                dataSet.remove(jj);
                                this.inputData[ii] = datum;
                                this.converters[ii] = conversion;
                            }
                        }
                    }
                    ++jj;
                }
                if (this.inputData[ii] == null) {
                    this.inputData = null;
                    break;
                }
                ++ii;
            }
        }
    }

    private boolean isAssignableFrom(String type, Data datum) {
        Object data = datum.getData();
        boolean assignable = false;
        if (type != null && type.equalsIgnoreCase(datum.getFormat())) {
            assignable = true;
        } else if (data != null) {
            try {
                Class<?> clazz = Class.forName(type, false, data.getClass().getClassLoader());
                if (clazz != null && clazz.isInstance(data)) {
                    assignable = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                assignable = false;
            }
        }
        return assignable;
    }

    private String[] separateInData(String inDataString) {
        String[] inData = inDataString.split(",");
        int ii = 0;
        while (ii < inData.length) {
            inData[ii] = inData[ii].trim();
            ++ii;
        }
        return inData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getItemId() {
        return this.internalId;
    }

    public Dictionary<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Dictionary<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Data[] getInputData() {
        return this.inputData;
    }

    public void setInputData(Data[] data) {
        this.setServiceReferenceFromBundle();
        try {
            this.dataSelected(data);
            this.tryConvertingDataToRequiredFormat();
        }
        catch (RuntimeException e) {
            String logMessage = String.format("Error: Unable to convert data for use by the algorithm:%n    %s", e.getMessage());
            this.log(1, logMessage, e);
            e.printStackTrace();
        }
    }

    public Long getInternalId() {
        return this.internalId;
    }

    protected void log(int logLevel, String message, Throwable exception) {
        LogService logger = (LogService)Activator.getCiShellContext().getService(LogService.class.getName());
        if (logger != null) {
            logger.log(this.serviceReference, logLevel, message, exception);
        } else {
            exception.printStackTrace();
        }
    }

    protected boolean tryConvertingDataToRequiredFormat() {
        int i = 0;
        while (i < this.inputData.length) {
            if (this.converters[i] != null) {
                try {
                    this.inputData[i] = this.converters[i][0].convert(this.inputData[i]);
                }
                catch (ConversionException e) {
                    String logMessage = String.format("Error: Unable to convert data for use by the algorithm:%n    %s", e.getMessage());
                    this.log(1, logMessage, e);
                    e.printStackTrace();
                    return false;
                }
                if (this.inputData[i] == null && i < this.inputData.length - 1) {
                    this.log(1, "The converter: " + this.converters[i].getClass().getName() + " returned a null result where data was " + "expected when converting the data to give " + "the algorithm.", new Throwable());
                    return false;
                }
                this.converters[i] = null;
            }
            ++i;
        }
        return true;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public void setServiceReferenceFromBundle() {
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = Activator.getContext().getAllServiceReferences(AlgorithmFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < serviceReferences.length) {
            String pid = (String)serviceReferences[i].getProperty("service.pid");
            if (pid.compareTo(this.pid) == 0) {
                this.serviceReference = serviceReferences[i];
                break;
            }
            ++i;
        }
    }

    private class AlgorithmProgressMonitor
    implements ProgressMonitor {
        private double totalWorkUnits;

        private AlgorithmProgressMonitor() {
        }

        public void describeWork(String currentWork) {
        }

        public void done() {
        }

        public boolean isCanceled() {
            return false;
        }

        public boolean isPaused() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setPaused(boolean value) {
        }

        public void start(int capabilities, int totalWorkUnits) {
        }

        public void start(int capabilities, double totalWorkUnits) {
            this.totalWorkUnits = totalWorkUnits;
        }

        public void worked(int work) {
            this.worked((double)work);
        }

        public void worked(double work) {
        }
    }
}

