/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.cishell.app.service.datamanager.DataManagerService;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.workflow.Activator;
import org.cishell.reference.gui.workflow.model.AlgorithmWorkflowItem;
import org.cishell.reference.gui.workflow.model.Workflow;
import org.cishell.reference.gui.workflow.model.WorkflowItem;
import org.osgi.framework.BundleContext;

public class NormalWorkflow
implements Workflow {
    private String name;
    private Long id;
    private Long lastCreatedID;
    private LinkedHashMap<Long, WorkflowItem> itemMap;

    public LinkedHashMap<Long, WorkflowItem> getMap() {
        return this.itemMap;
    }

    public void setMap(LinkedHashMap<Long, WorkflowItem> map) {
        this.itemMap = map;
    }

    public NormalWorkflow(String name, Long id) {
        this.name = name;
        this.id = id;
        this.itemMap = new LinkedHashMap();
        this.lastCreatedID = new Long(1L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getInternalId() {
        return this.id;
    }

    @Override
    public void setInternalId(Long id) {
        this.id = id;
    }

    @Override
    public void run() {
        BundleContext bundleContext = Activator.getContext();
        DataManagerService dataManager = (DataManagerService)bundleContext.getService(bundleContext.getServiceReference(DataManagerService.class.getName()));
        Data[] data = dataManager.getSelectedData();
        for (Map.Entry<Long, WorkflowItem> entry : this.itemMap.entrySet()) {
            WorkflowItem item = entry.getValue();
            if (!(item instanceof AlgorithmWorkflowItem)) continue;
            AlgorithmWorkflowItem algo = (AlgorithmWorkflowItem)item;
            algo.setInputData(data);
            data = (Data[])algo.run();
        }
        if (data != null && data.length != 0) {
            int ii = 0;
            while (ii < data.length) {
                dataManager.addData(data[ii]);
                ++ii;
            }
            dataManager.setSelectedData(data);
        }
    }

    @Override
    public void add(WorkflowItem item) {
        this.itemMap.put(item.getItemId(), item);
    }

    public Long getUniqueInternalId() {
        while (this.itemMap.containsKey(this.lastCreatedID)) {
            this.lastCreatedID = this.lastCreatedID + 1L;
        }
        return this.lastCreatedID;
    }

    @Override
    public void remove(WorkflowItem item) {
        try {
            Set<Map.Entry<Long, WorkflowItem>> set = this.itemMap.entrySet();
            Iterator<Map.Entry<Long, WorkflowItem>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, WorkflowItem> me = iterator.next();
                if (me.getKey() < item.getItemId()) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

