/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.model;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cishell.app.service.scheduler.SchedulerListener;
import org.cishell.app.service.scheduler.SchedulerService;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.workflow.Activator;

public class SchedulerContentModel
implements SchedulerListener {
    private static final SchedulerContentModel INSTANCE = new SchedulerContentModel();
    private SchedulerService schedulerService = Activator.getSchedulerService();
    private List schedulerListenerList;
    private Map classNameToPersistentMap;
    private boolean isRunning;

    private SchedulerContentModel() {
        if (this.schedulerService != null) {
            this.schedulerService.addSchedulerListener((SchedulerListener)this);
        }
        this.schedulerListenerList = new Vector();
        this.classNameToPersistentMap = new Hashtable();
    }

    public static SchedulerContentModel getInstance() {
        return INSTANCE;
    }

    public void register(SchedulerListener listener) {
        this.schedulerListenerList.add(listener);
    }

    public void deregister(SchedulerListener listener) {
        this.schedulerListenerList.remove(listener);
    }

    public void persistObject(String className, Object o) {
        this.classNameToPersistentMap.put(className, o);
    }

    public Object getPersistedObject(String className) {
        return this.classNameToPersistentMap.get(className);
    }

    public boolean isRunning() {
        return this.schedulerService.isRunning();
    }

    public void algorithmError(Algorithm algorithm, Throwable error) {
        int i = 0;
        while (i < this.schedulerListenerList.size()) {
            SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
            schedulerListener.algorithmError(algorithm, error);
            ++i;
        }
    }

    public void algorithmFinished(Algorithm algorithm, Data[] createdData) {
        int i = 0;
        while (i < this.schedulerListenerList.size()) {
            SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
            schedulerListener.algorithmFinished(algorithm, createdData);
            ++i;
        }
    }

    public void algorithmRescheduled(Algorithm algorithm, Calendar time) {
        int i = 0;
        while (i < this.schedulerListenerList.size()) {
            SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
            schedulerListener.algorithmRescheduled(algorithm, time);
            ++i;
        }
    }

    public void algorithmScheduled(Algorithm algorithm, Calendar time) {
        System.out.println("Algorithm Scheduled");
        int i = 0;
        while (i < this.schedulerListenerList.size()) {
            SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
            schedulerListener.algorithmScheduled(algorithm, time);
            ++i;
        }
    }

    public void algorithmStarted(Algorithm algorithm) {
        int i = 0;
        while (i < this.schedulerListenerList.size()) {
            SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
            schedulerListener.algorithmStarted(algorithm);
            ++i;
        }
    }

    public void algorithmUnscheduled(Algorithm algorithm) {
        int i = 0;
        while (i < this.schedulerListenerList.size()) {
            SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
            schedulerListener.algorithmUnscheduled(algorithm);
            ++i;
        }
    }

    public void schedulerCleared() {
        int i = 0;
        while (i < this.schedulerListenerList.size()) {
            SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
            schedulerListener.schedulerCleared();
            ++i;
        }
    }

    public void schedulerRunStateChanged(boolean isRunning) {
        if (this.isRunning != isRunning) {
            this.isRunning = isRunning;
            this.schedulerService.setRunning(isRunning);
        } else {
            int i = 0;
            while (i < this.schedulerListenerList.size()) {
                SchedulerListener schedulerListener = (SchedulerListener)this.schedulerListenerList.get(i);
                schedulerListener.schedulerRunStateChanged(this.isRunning);
                ++i;
            }
        }
    }
}

