/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cishell.reference.gui.workflow.Utilities.Utils;
import org.cishell.reference.gui.workflow.model.WorkflowItem;
import org.cishell.reference.gui.workflow.views.WorkflowTreeItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AlgorithmItemGUI
implements WorkflowTreeItem {
    private static String brandPluginID;
    private Image algorithmIcon;
    private Image parametersIcon;
    private Image workflowIcon;
    private Image workflow_mgrIcon;
    private Image unknownIcon;
    private Map<String, Image> typeToImage = new HashMap<String, Image>();
    private Collection<WorkflowTreeItem> children = new ArrayList<WorkflowTreeItem>();
    private WorkflowItem wfItem;
    private String label;
    private WorkflowTreeItem parent;
    private static final String DEFAULT_IMAGE_LOCATION;

    static {
        DEFAULT_IMAGE_LOCATION = String.valueOf(File.separator) + "unknown.png";
    }

    public AlgorithmItemGUI(WorkflowItem wfItem, WorkflowTreeItem parent, String brandPluginID) {
        this.wfItem = wfItem;
        this.label = wfItem.getName();
        this.parent = parent;
        this.algorithmIcon = Utils.getImage("algorithm.png", brandPluginID);
        this.parametersIcon = Utils.getImage("parameters.png", brandPluginID);
        this.workflowIcon = Utils.getImage("workflow.png", brandPluginID);
        this.workflow_mgrIcon = Utils.getImage("workflow_mgr.png", brandPluginID);
        this.unknownIcon = Utils.getImage("unknown.png", brandPluginID);
        this.registerImage("Model", this.algorithmIcon);
        this.registerImage("Table", this.parametersIcon);
        this.registerImage("Tree", this.workflowIcon);
        this.registerImage("Unknown", this.workflow_mgrIcon);
        this.registerImage("Unknown", this.unknownIcon);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setAlgorithmLabel(String algorithmLabel) {
        this.label = algorithmLabel;
    }

    @Override
    public WorkflowTreeItem getParent() {
        return this.parent;
    }

    @Override
    public void addChild(WorkflowTreeItem item) {
        this.children.add(item);
    }

    @Override
    public Object[] getChildren() {
        return this.children.toArray();
    }

    public void removeChild(AlgorithmItemGUI item) {
        this.children.remove(item);
    }

    @Override
    public Image getIcon() {
        return this.algorithmIcon;
    }

    public void registerImage(String type, Image image) {
        this.typeToImage.put(type, image);
    }

    public static Image getDefaultImage() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)brandPluginID, (String)DEFAULT_IMAGE_LOCATION);
        return imageDescriptor.createImage();
    }

    @Override
    public String getType() {
        return "AlgorithmUIItem";
    }

    @Override
    public void removeAllChildren() {
        this.children.clear();
    }

    @Override
    public boolean hasChild(WorkflowTreeItem wfTreeItem) {
        return this.children.contains(wfTreeItem);
    }

    @Override
    public void removeChild(WorkflowTreeItem wfTreeItem) {
        this.children.remove(wfTreeItem);
    }

    public WorkflowItem getWfItem() {
        return this.wfItem;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }
}

