/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.views;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.reference.gui.workflow.Utilities.Utils;
import org.cishell.reference.gui.workflow.controller.WorkflowManager;
import org.cishell.reference.gui.workflow.model.AlgorithmWorkflowItem;
import org.cishell.reference.gui.workflow.model.NormalWorkflow;
import org.cishell.reference.gui.workflow.model.Workflow;
import org.cishell.reference.gui.workflow.model.WorkflowItem;
import org.cishell.reference.gui.workflow.views.AlgorithmItemGUI;
import org.cishell.reference.gui.workflow.views.GeneralTreeItem;
import org.cishell.reference.gui.workflow.views.WorkflowGUI;
import org.cishell.reference.gui.workflow.views.WorkflowTreeItem;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;

public class ManageView {
    private final String PARAMETER_IMAGE_NAME = "parameters.png";

    public void updateUI(Tree tree, TreeViewer viewer, String brandPluginID) {
        tree.clearAll(true);
        WorkflowGUI rootItem = new WorkflowGUI(null, null, 2, brandPluginID);
        viewer.setInput((Object)rootItem);
        viewer.expandAll();
        LinkedHashMap<Long, Workflow> map = WorkflowManager.getInstance().getMap();
        for (Map.Entry<Long, Workflow> entry : map.entrySet()) {
            NormalWorkflow wf = (NormalWorkflow)entry.getValue();
            WorkflowGUI wfnew = new WorkflowGUI(wf, rootItem, 0, brandPluginID);
            rootItem.addChild((WorkflowTreeItem)wfnew);
            LinkedHashMap<Long, WorkflowItem> itemMap = wf.getMap();
            WorkflowTreeItem parent = wfnew;
            for (Map.Entry<Long, WorkflowItem> itemEntry : itemMap.entrySet()) {
                AlgorithmWorkflowItem algoItem = (AlgorithmWorkflowItem)itemEntry.getValue();
                AlgorithmItemGUI dataItem = new AlgorithmItemGUI(algoItem, parent, brandPluginID);
                parent.addChild(dataItem);
                parent = dataItem;
                Dictionary<String, Object> params = algoItem.getParameters();
                if (params == null || params.isEmpty()) continue;
                GeneralTreeItem paramLabel = new GeneralTreeItem("Parameters", "label", dataItem, Utils.getImage("parameters.png", brandPluginID));
                dataItem.addChild(paramLabel);
                Enumeration<String> e = params.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    String strvalue = "";
                    Object value = params.get(key);
                    if (value != null) {
                        strvalue = value.toString();
                    }
                    GeneralTreeItem paramName = new GeneralTreeItem(key, "ParamName", paramLabel, Utils.getImage("parameters.png", brandPluginID));
                    paramLabel.addChildren(paramName);
                    GeneralTreeItem paramValue = new GeneralTreeItem(strvalue, "ParamValue", paramName, Utils.getImage("parameters.png", brandPluginID));
                    paramName.addChildren(paramValue);
                }
            }
        }
        viewer.refresh();
        viewer.expandAll();
    }

    void addworkflow(WorkflowGUI rootItem, Workflow workflow, String brandPluginID) {
        NormalWorkflow wf = (NormalWorkflow)workflow;
        WorkflowGUI wfnew = new WorkflowGUI(wf, rootItem, 0, brandPluginID);
        rootItem.addChild(wfnew);
        LinkedHashMap<Long, WorkflowItem> itemMap = wf.getMap();
        WorkflowTreeItem parent = wfnew;
        for (Map.Entry<Long, WorkflowItem> itemEntry : itemMap.entrySet()) {
            AlgorithmWorkflowItem algoItem = (AlgorithmWorkflowItem)itemEntry.getValue();
            AlgorithmItemGUI dataItem = new AlgorithmItemGUI(algoItem, parent, brandPluginID);
            parent.addChild(dataItem);
            parent = dataItem;
            Dictionary<String, Object> params = algoItem.getParameters();
            Dictionary<String, String> nameToId = algoItem.getNameToId();
            if (params == null || params.isEmpty()) continue;
            GeneralTreeItem paramLabel = new GeneralTreeItem("Parameters", "label", dataItem, Utils.getImage("parameters.png", brandPluginID));
            dataItem.addChild(paramLabel);
            Enumeration<String> e = nameToId.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String strvalue = "";
                Object value = algoItem.getParameterValue(key);
                if (value != null) {
                    strvalue = value.toString();
                }
                GeneralTreeItem paramName = new GeneralTreeItem(key, "ParamName", paramLabel, Utils.getImage("parameters.png", brandPluginID));
                paramLabel.addChildren(paramName);
                GeneralTreeItem paramValue = new GeneralTreeItem(strvalue, "ParamValue", paramName, Utils.getImage("parameters.png", brandPluginID));
                paramName.addChildren(paramValue);
            }
        }
    }
}

