/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cishell.reference.gui.workflow.model.Workflow;
import org.cishell.reference.gui.workflow.views.AlgorithmItemGUI;
import org.cishell.reference.gui.workflow.views.WorkflowTreeItem;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkflowGUI
implements WorkflowTreeItem {
    private Image algorithmIcon;
    private Image parametersIcon;
    private Image workflowIcon;
    private Image workflow_mgrIcon;
    private Image unknownIcon;
    private Workflow workflow;
    private Map<String, Image> typeToImage = new HashMap<String, Image>();
    private Collection<WorkflowGUI> children = new ArrayList<WorkflowGUI>();
    private Collection<AlgorithmItemGUI> workFlowItemChildren = new ArrayList<AlgorithmItemGUI>();
    private String label;
    private WorkflowGUI parent;
    private static final String DEFAULT_IMAGE_LOCATION = String.valueOf(File.separator) + "unknown.png";

    public WorkflowGUI(Workflow workflow, WorkflowGUI parent, int type, String brandPluginID) {
        if (workflow != null) {
            this.label = workflow.getName();
        }
        this.workflow = workflow;
        this.algorithmIcon = WorkflowGUI.getImage("algorithm.png", brandPluginID);
        this.parametersIcon = WorkflowGUI.getImage("parameters.png", brandPluginID);
        this.workflowIcon = WorkflowGUI.getImage("workflow.png", brandPluginID);
        this.workflow_mgrIcon = WorkflowGUI.getImage("workflow_mgr.png", brandPluginID);
        this.unknownIcon = WorkflowGUI.getImage("unknown.png", brandPluginID);
        this.registerImage("Model", this.algorithmIcon);
        this.registerImage("Table", this.parametersIcon);
        this.registerImage("Tree", this.workflowIcon);
        this.registerImage("Unknown", this.workflow_mgrIcon);
        this.registerImage("Unknown", this.unknownIcon);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setAlgorithmLabel(String algorithmLabel) {
        this.label = algorithmLabel;
    }

    @Override
    public WorkflowTreeItem getParent() {
        return this.parent;
    }

    public void addChild(WorkflowGUI item) {
        this.children.add(item);
    }

    @Override
    public Object[] getChildren() {
        return this.workFlowItemChildren.toArray();
    }

    public Object[] getRootsChildren() {
        return this.children.toArray();
    }

    public void addChild(AlgorithmItemGUI item) {
        this.workFlowItemChildren.add(item);
    }

    public void removeChild(WorkflowGUI item) {
        this.children.remove(item);
    }

    @Override
    public Image getIcon() {
        return this.workflowIcon;
    }

    public void registerImage(String type, Image image) {
        this.typeToImage.put(type, image);
    }

    public static Image getImage(String name, String brandPluginID) {
        if (Platform.isRunning()) {
            String imageLocation = String.format("%sicons%s%s", File.separator, File.separator, name);
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)brandPluginID, (String)imageLocation);
            if (imageDescriptor != null) {
                return imageDescriptor.createImage();
            }
            String errorMessage = String.format("Could not find the icon '%s' in '%s'. Using the default image instead.", imageLocation, brandPluginID);
            System.err.println(errorMessage);
            return WorkflowGUI.getDefaultImage();
        }
        String format = "Could not obtain the image '%s' in '%s', since the platform was not running (?). Using the default image instead.";
        String errorMessage = String.format(format, name, brandPluginID);
        System.err.println(errorMessage);
        return WorkflowGUI.getDefaultImage();
    }

    private static Image getDefaultImage() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(null, (String)DEFAULT_IMAGE_LOCATION);
        return imageDescriptor.createImage();
    }

    @Override
    public String getType() {
        return "Workflow";
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void removeAllChildren() {
        this.workFlowItemChildren.clear();
    }

    @Override
    public boolean hasChild(WorkflowTreeItem wfTreeItem) {
        return this.workFlowItemChildren.contains(wfTreeItem);
    }

    @Override
    public void removeChild(WorkflowTreeItem wfTreeItem) {
        this.workFlowItemChildren.remove(wfTreeItem);
    }

    @Override
    public void addChild(WorkflowTreeItem wfTreeItem) {
        if (wfTreeItem instanceof AlgorithmItemGUI) {
            this.workFlowItemChildren.add((AlgorithmItemGUI)wfTreeItem);
        }
    }
}

