/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.workflow.views;

import java.util.Calendar;
import java.util.Dictionary;
import org.cishell.app.service.scheduler.SchedulerListener;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.menumanager.menu.AlgorithmWrapper;
import org.cishell.reference.gui.workflow.Activator;
import org.cishell.reference.gui.workflow.Utilities.Utils;
import org.cishell.reference.gui.workflow.controller.WorkflowMaker;
import org.cishell.reference.gui.workflow.controller.WorkflowManager;
import org.cishell.reference.gui.workflow.model.AlgorithmWorkflowItem;
import org.cishell.reference.gui.workflow.model.NormalWorkflow;
import org.cishell.reference.gui.workflow.model.SchedulerContentModel;
import org.cishell.reference.gui.workflow.model.Workflow;
import org.cishell.reference.gui.workflow.views.AlgorithmItemGUI;
import org.cishell.reference.gui.workflow.views.DataTreeContentProvider;
import org.cishell.reference.gui.workflow.views.DataTreeLabelProvider;
import org.cishell.reference.gui.workflow.views.GeneralTreeItem;
import org.cishell.reference.gui.workflow.views.ManageView;
import org.cishell.reference.gui.workflow.views.WorkflowGUI;
import org.cishell.reference.gui.workflow.views.WorkflowMode;
import org.cishell.reference.gui.workflow.views.WorkflowTreeItem;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class WorkflowView
extends ViewPart
implements SchedulerListener {
    private static WorkflowView workFlowView;
    public static final String ID_VIEW = "org.cishell.reference.gui.workflow.views.WorkflowView";
    private TreeViewer viewer;
    private WorkflowGUI rootItem;
    private WorkflowGUI currentWorkFlowItem;
    private Tree tree;
    private Menu menu;
    private Menu whiteSpacemenu;
    private SaveListener saveListener;
    private LoadListener loadListener;
    private RunListener runListener;
    private DeleteListener deleteListener;
    private WorkflowMode mode;
    private TreeEditor editor;
    private Text newEditor;
    private boolean updatingTreeItem;
    private WorkflowTreeItem currentParentItem;
    private String brandPluginID;

    public WorkflowView(String brandPluginID) {
        this.brandPluginID = brandPluginID;
        workFlowView = this;
    }

    public static WorkflowView getDefault() {
        return workFlowView;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new DataTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DataTreeLabelProvider());
        this.rootItem = new WorkflowGUI(null, null, 2, this.brandPluginID);
        this.viewer.setInput((Object)this.rootItem);
        this.viewer.expandAll();
        this.tree = this.viewer.getTree();
        this.tree.addSelectionListener((SelectionListener)new DatamodelSelectionListener());
        this.tree.addMouseListener((MouseListener)new ContextMenuListener());
        this.menu = new Menu((Control)this.tree);
        this.menu.setVisible(false);
        MenuItem changeItem = new MenuItem(this.menu, 8);
        changeItem.setText("Edit");
        changeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WorkflowView.this.handleInput();
            }
        });
        MenuItem runItem = new MenuItem(this.menu, 8);
        runItem.setText("Run");
        this.runListener = new RunListener();
        runItem.addListener(13, (Listener)this.runListener);
        MenuItem saveItem = new MenuItem(this.menu, 8);
        saveItem.setText("Save");
        this.saveListener = new SaveListener();
        saveItem.addListener(13, (Listener)this.saveListener);
        MenuItem deleteItem = new MenuItem(this.menu, 8);
        deleteItem.setText("Delete");
        this.deleteListener = new DeleteListener();
        deleteItem.addListener(13, (Listener)this.deleteListener);
        this.editor = new TreeEditor(this.tree);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.whiteSpacemenu = new Menu((Control)this.tree);
        this.whiteSpacemenu.setVisible(false);
        MenuItem newItem = new MenuItem(this.whiteSpacemenu, 8);
        newItem.setText("New Workflow");
        MenuItem loadItem = new MenuItem(this.whiteSpacemenu, 8);
        loadItem.setText("Load");
        this.loadListener = new LoadListener();
        loadItem.addListener(13, (Listener)this.loadListener);
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = WorkflowView.this.getSite().getPage();
                    page.showView("org.cishell.reference.gui.datamanager.DataManagerView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        newItem.addListener(13, (Listener)new NewWorkflow());
        this.addNewWorkflow("Workflow ");
        SchedulerContentModel.getInstance().register(this);
    }

    protected String getMetaTypeID(ServiceReference ref) {
        String pid = (String)ref.getProperty("service.pid");
        String metatype_pid = (String)ref.getProperty("parameters_pid");
        if (metatype_pid == null) {
            metatype_pid = pid;
        }
        return metatype_pid;
    }

    public void algorithmScheduled(Algorithm algorithm, Calendar time) {
    }

    public void algorithmRescheduled(Algorithm algorithm, Calendar time) {
    }

    public void algorithmUnscheduled(Algorithm algorithm) {
    }

    public void algorithmStarted(Algorithm algorithm) {
    }

    public void addNewWorkflow(String name) {
        WorkflowGUI dataItem;
        Workflow workfFlow = WorkflowManager.getInstance().createWorkflow(name, "NormalWorkflow");
        this.currentWorkFlowItem = dataItem = new WorkflowGUI(workfFlow, this.currentWorkFlowItem, 1, this.brandPluginID);
        this.currentParentItem = dataItem;
        this.rootItem.addChild(dataItem);
        this.refresh(dataItem);
    }

    public void algorithmFinished(Algorithm algorithm, Data[] createdData) {
        if (this.mode == WorkflowMode.RUNNING) {
            return;
        }
        Dictionary parameters = null;
        if (algorithm instanceof AlgorithmWrapper) {
            AlgorithmWrapper algo = (AlgorithmWrapper)algorithm;
            parameters = algo.getParameters();
        }
        ServiceReference serviceReference = Activator.getSchedulerService().getServiceReference(algorithm);
        String algorithmLabel = "";
        if (serviceReference != null) {
            algorithmLabel = (String)serviceReference.getProperty("label");
        }
        AlgorithmFactory factory = (AlgorithmFactory)Activator.getContext().getService(serviceReference);
        String pid = (String)serviceReference.getProperty("service.pid");
        AlgorithmWorkflowItem wfi = new AlgorithmWorkflowItem(algorithmLabel, ((NormalWorkflow)this.currentWorkFlowItem.getWorkflow()).getUniqueInternalId(), pid);
        wfi.setParameters(parameters);
        wfi.setWorkflow(this.currentWorkFlowItem.getWorkflow());
        this.currentWorkFlowItem.getWorkflow().add(wfi);
        AlgorithmItemGUI dataItem = new AlgorithmItemGUI(wfi, this.currentParentItem, this.brandPluginID);
        this.currentParentItem.addChild(dataItem);
        this.currentParentItem = dataItem;
        this.refresh(dataItem);
        String metatypePID = this.getMetaTypeID(serviceReference);
        MetaTypeProvider provider = null;
        try {
            provider = this.getPossiblyMutatedMetaTypeProvider(metatypePID, pid, factory, serviceReference);
        }
        catch (AlgorithmCreationFailedException e) {
            String format = "An error occurred when creating the algorithm \"%s\" with the data you provided.  (Reason: %s)";
            String.format(format, serviceReference.getProperty("label"), e.getMessage());
            return;
        }
        catch (Exception exception) {
            return;
        }
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        GeneralTreeItem paramItem = new GeneralTreeItem("Parameters", "label", dataItem, Utils.getImage("parameters.png", this.brandPluginID));
        dataItem.addChild(paramItem);
        ObjectClassDefinition obj = provider.getObjectClassDefinition(metatypePID, null);
        if (obj != null) {
            AttributeDefinition[] attr = obj.getAttributeDefinitions(-1);
            int i = 0;
            while (i < attr.length) {
                String id = attr[i].getID();
                String name = attr[i].getName();
                wfi.add(name, id);
                Object valueRaw = parameters.get(id);
                String value = "";
                if (valueRaw != null) {
                    value = valueRaw.toString();
                }
                GeneralTreeItem paramName = new GeneralTreeItem(name, "ParamName", paramItem, Utils.getImage("parameters.png", this.brandPluginID));
                paramItem.addChildren(paramName);
                GeneralTreeItem paramValue = new GeneralTreeItem(value, "ParamValue", paramName, Utils.getImage("parameters.png", this.brandPluginID));
                paramName.addChildren(paramValue);
                ++i;
            }
        }
        this.refresh(paramItem);
    }

    private void refresh(final WorkflowTreeItem item) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                if (!WorkflowView.this.tree.isDisposed()) {
                    WorkflowView.this.viewer.refresh();
                    WorkflowView.this.viewer.expandToLevel((Object)item, 0);
                }
            }
        });
    }

    public void algorithmError(Algorithm algorithm, Throwable error) {
    }

    public void schedulerRunStateChanged(boolean isRunning) {
    }

    public void schedulerCleared() {
    }

    private void guiRun(Runnable run) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            run.run();
        } else {
            Display.getDefault().syncExec(run);
        }
    }

    public WorkflowMode getMode() {
        return this.mode;
    }

    protected MetaTypeProvider getPossiblyMutatedMetaTypeProvider(String metatypePID, String pid, AlgorithmFactory factory, ServiceReference serviceRef) throws AlgorithmCreationFailedException {
        MetaTypeInformation provider = null;
        MetaTypeService metaTypeService = (MetaTypeService)Activator.getService(MetaTypeService.class.getName());
        if (metaTypeService != null) {
            provider = metaTypeService.getMetaTypeInformation(serviceRef.getBundle());
        }
        return provider;
    }

    public boolean isRootItem(WorkflowGUI wfg) {
        return this.rootItem.equals(wfg);
    }

    public void UpdateUI() {
        ManageView mview = new ManageView();
        mview.updateUI(this.tree, this.viewer, this.brandPluginID);
    }

    public void addWorflowtoUI(Workflow wf) {
        ManageView mview = new ManageView();
        mview.addworkflow(this.rootItem, wf, this.brandPluginID);
        this.viewer.refresh();
    }

    private void handleInput() {
        TreeItem[] selection;
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if ((selection = this.tree.getSelection()).length != 1) {
            return;
        }
        final TreeItem item = selection[0];
        if (item == null) {
            return;
        }
        this.newEditor = new Text((Composite)this.tree, 0);
        this.newEditor.setText(item.getText());
        this.newEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!WorkflowView.this.updatingTreeItem) {
                    WorkflowView.this.updateText(WorkflowView.this.newEditor.getText(), item);
                }
            }
        });
        this.newEditor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' && !WorkflowView.this.updatingTreeItem) {
                    WorkflowView.this.updateText(WorkflowView.this.newEditor.getText(), item);
                } else if (e.keyCode == 27) {
                    WorkflowView.this.newEditor.dispose();
                }
            }
        });
        this.newEditor.selectAll();
        this.newEditor.setFocus();
        this.editor.setEditor((Control)this.newEditor, item);
    }

    private void updateText(String newLabel, TreeItem item) {
        this.updatingTreeItem = true;
        if (newLabel.startsWith(">")) {
            newLabel = newLabel.substring(1);
        }
        this.editor.getItem().setText(newLabel);
        WorkflowTreeItem wfTreeItem = (WorkflowTreeItem)item.getData();
        if (wfTreeItem.getType() == "ParamValue") {
            try {
                String paramName = wfTreeItem.getParent().getLabel();
                WorkflowTreeItem alfoITem = wfTreeItem.getParent().getParent().getParent();
                AlgorithmWorkflowItem wfg = (AlgorithmWorkflowItem)((AlgorithmItemGUI)alfoITem).getWfItem();
                Object obj = wfg.getParameterValue(paramName);
                if (obj != null) {
                    if (obj instanceof String) {
                        obj = newLabel;
                    } else if (obj instanceof Integer) {
                        obj = Integer.parseInt(newLabel);
                    } else if (obj instanceof Boolean) {
                        obj = Boolean.parseBoolean(newLabel);
                    } else if (obj instanceof Float) {
                        obj = Float.valueOf(Float.parseFloat(newLabel));
                    } else if (obj instanceof Double) {
                        obj = Double.parseDouble(newLabel);
                    } else if (obj instanceof Long) {
                        obj = Long.parseLong(newLabel);
                    } else if (obj instanceof Short) {
                        obj = Short.parseShort(newLabel);
                    }
                } else {
                    obj = newLabel;
                }
                wfg.addParameter(paramName, obj);
                wfTreeItem.setLabel(newLabel);
            }
            catch (Exception exception) {
                this.viewer.refresh();
                this.newEditor.dispose();
                this.updatingTreeItem = false;
            }
        } else if (wfTreeItem.getType() == "Workflow") {
            wfTreeItem.setLabel(newLabel);
            ((WorkflowGUI)wfTreeItem).getWorkflow().setName(newLabel);
        }
        this.viewer.refresh();
        this.newEditor.dispose();
        this.updatingTreeItem = false;
    }

    public void setFocus() {
    }

    private class ContextMenuListener
    extends MouseAdapter {
        private ContextMenuListener() {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 3) {
                TreeItem item = WorkflowView.this.tree.getItem(new Point(event.x, event.y));
                if (item != null) {
                    WorkflowView.this.menu.setVisible(true);
                    WorkflowView.this.whiteSpacemenu.setVisible(false);
                } else {
                    WorkflowView.this.menu.setVisible(false);
                    WorkflowView.this.whiteSpacemenu.setVisible(true);
                }
            }
        }
    }

    private class DatamodelSelectionListener
    extends SelectionAdapter {
        private DatamodelSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
        }
    }

    private class DeleteListener
    implements Listener {
        private DeleteListener() {
        }

        public void handleEvent(Event arg0) {
            try {
                TreeItem[] items = WorkflowView.this.tree.getSelection();
                if (items.length != 1) {
                    return;
                }
                WorkflowTreeItem itm = (WorkflowTreeItem)items[0].getData();
                String type = itm.getType();
                if (type == "Workflow") {
                    WorkflowGUI wfGUI = (WorkflowGUI)itm;
                    WorkflowManager.getInstance().removeWorkflow(wfGUI.getWorkflow());
                    itm.removeAllChildren();
                    WorkflowView.this.rootItem.removeChild(wfGUI);
                    WorkflowView.this.viewer.refresh();
                    if (WorkflowView.this.rootItem.getRootsChildren().length == 0 || WorkflowView.this.currentWorkFlowItem == wfGUI) {
                        WorkflowView.this.addNewWorkflow("Workflow ");
                    }
                } else if (type == "AlgorithmUIItem") {
                    AlgorithmItemGUI aiGUI = (AlgorithmItemGUI)itm;
                    AlgorithmWorkflowItem wfItem = (AlgorithmWorkflowItem)aiGUI.getWfItem();
                    Workflow wf = wfItem.getWorkflow();
                    WorkflowTreeItem parent = itm.getParent();
                    itm.removeAllChildren();
                    parent.removeChild(itm);
                    WorkflowView.this.viewer.refresh();
                    wf.remove(wfItem);
                    if (parent.getChildren().length == 0 || WorkflowView.this.currentParentItem == aiGUI) {
                        WorkflowView.this.currentParentItem = parent;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class LoadListener
    implements Listener {
        private LoadListener() {
        }

        public void handleEvent(Event event) {
            WorkflowMaker loadState = new WorkflowMaker();
            loadState.load();
        }
    }

    private class NewWorkflow
    implements Listener {
        private NewWorkflow() {
        }

        public void handleEvent(Event event) {
            WorkflowView.this.addNewWorkflow("Workflow ");
        }
    }

    private class RunListener
    implements Listener {
        private RunListener() {
        }

        public void handleEvent(Event event) {
            TreeItem[] items = WorkflowView.this.tree.getSelection();
            if (items.length != 1) {
                return;
            }
            WorkflowTreeItem itm = (WorkflowTreeItem)items[0].getData();
            String type = itm.getType();
            if (type == "Workflow") {
                WorkflowView.this.mode = WorkflowMode.RUNNING;
                ((WorkflowGUI)itm).getWorkflow().run();
                WorkflowView.this.mode = WorkflowMode.STOPPED;
            }
        }
    }

    private class SaveListener
    implements Listener {
        private SaveListener() {
        }

        public void handleEvent(Event event) {
            TreeItem[] items = WorkflowView.this.tree.getSelection();
            if (items.length != 1) {
                return;
            }
            WorkflowTreeItem itm = (WorkflowTreeItem)items[0].getData();
            String type = itm.getType();
            if (type == "Workflow") {
                WorkflowGUI wfGUI = (WorkflowGUI)itm;
                WorkflowMaker savedState = new WorkflowMaker();
                savedState.save(wfGUI.getWorkflow());
            }
        }
    }
}

