/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.prefs.admin.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.cishell.reference.prefs.admin.PrefAdmin;
import org.cishell.reference.prefs.admin.PrefPage;
import org.cishell.reference.prefs.admin.PrefsByService;
import org.cishell.reference.prefs.admin.internal.PrefInfoGrabber;
import org.cishell.reference.prefs.admin.internal.PrefReferenceProcessor;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeService;

public class PrefAdminImpl
implements PrefAdmin,
ConfigurationPlugin,
ConfigurationListener {
    private LogService log;
    private MetaTypeService mts;
    private ConfigurationAdmin ca;
    private PrefInfoGrabber prefInfoGrabber;
    private PrefReferenceProcessor prefProcessor;
    private List prefReferencesToBeProcessed = new ArrayList();
    private List prefHolderReferences = new ArrayList();
    private boolean hasBeenActivated = false;

    @Override
    public PrefPage[] getLocalPrefPages() {
        return this.prefProcessor.getAllLocalPrefPages();
    }

    @Override
    public PrefPage[] getGlobalPrefPages() {
        return this.prefProcessor.getAllGlobalPrefPages();
    }

    @Override
    public PrefPage[] getParamPrefPages() {
        return this.prefProcessor.getAllParamPrefPages();
    }

    @Override
    public PrefsByService[] getPrefsByService() {
        return this.prefProcessor.getAllPrefsByService();
    }

    protected void activate(ComponentContext ctxt) {
        this.log = (LogService)ctxt.locateService("LOG");
        this.mts = (MetaTypeService)ctxt.locateService("MTS");
        this.ca = (ConfigurationAdmin)ctxt.locateService("CS");
        this.prefInfoGrabber = new PrefInfoGrabber(this.log, this.mts, this.ca);
        this.prefProcessor = new PrefReferenceProcessor(this.log, this.prefInfoGrabber);
        this.hasBeenActivated = true;
        this.prefProcessor.processPrefReferences(this.prefReferencesToBeProcessed.toArray(new ServiceReference[0]));
        this.prefReferencesToBeProcessed.clear();
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    protected void prefHolderRegistered(ServiceReference prefHolder) {
        this.prefReferencesToBeProcessed.add(prefHolder);
        if (this.hasBeenActivated) {
            this.prefProcessor.processPrefReferences(this.prefReferencesToBeProcessed.toArray(new ServiceReference[0]));
            this.prefReferencesToBeProcessed.clear();
        }
        this.prefHolderReferences.add(prefHolder);
    }

    protected void prefHolderUnregistered(ServiceReference prefHolder) {
        this.prefHolderReferences.remove(prefHolder);
    }

    public void modifyConfiguration(ServiceReference reference, Dictionary properties) {
        PrefPage[] globalPrefPages = this.getGlobalPrefPages();
        int ii = 0;
        while (ii < globalPrefPages.length) {
            PrefPage globalPrefPage = globalPrefPages[ii];
            Configuration globalPrefConf = globalPrefPage.getPrefConf();
            String namespace = globalPrefConf.getPid();
            Dictionary globalPrefDict = globalPrefConf.getProperties();
            Enumeration ids = globalPrefDict.keys();
            while (ids.hasMoreElements()) {
                String id = (String)ids.nextElement();
                String value = (String)globalPrefDict.get(id);
                String keyForConfiguration = String.valueOf(namespace) + "." + id;
                properties.put(keyForConfiguration, value);
            }
            ++ii;
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1) {
            if (this.isFromGlobalConf(event.getPid())) {
                this.sendGlobalPreferences();
            }
        } else {
            event.getType();
        }
    }

    private void sendGlobalPreferences() {
        try {
            int ii = 0;
            while (ii < this.prefHolderReferences.size()) {
                ServiceReference prefHolder = (ServiceReference)this.prefHolderReferences.get(ii);
                if (prefHolder.getProperty("receive_prefs") != null && prefHolder.getProperty("receive_prefs").equals("true")) {
                    Configuration localPrefConf = this.ca.getConfiguration((String)prefHolder.getProperty("service.pid"));
                    try {
                        localPrefConf.update();
                    }
                    catch (IOException e) {
                        this.log.log(1, "Unable to update configuration for " + localPrefConf.getPid(), (Throwable)e);
                    }
                }
                ++ii;
            }
        }
        catch (IOException e) {
            this.log.log(1, "Unable to obtain all configuration objects", (Throwable)e);
        }
    }

    private boolean isFromGlobalConf(String pid) {
        return pid.substring(0, pid.length() - 1).endsWith(".prefs.global") || pid.endsWith(".prefs.global");
    }
}

