/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.prefs.admin.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.cishell.framework.algorithm.AlgorithmProperty;
import org.cishell.framework.userprefs.UserPrefsProperty;
import org.cishell.reference.prefs.admin.PreferenceOCD;
import org.cishell.reference.prefs.admin.internal.PreferenceOCDImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class PrefInfoGrabber
implements UserPrefsProperty,
AlgorithmProperty {
    private LogService log;
    private MetaTypeService mts;
    private ConfigurationAdmin ca;

    public PrefInfoGrabber(LogService log, MetaTypeService mts, ConfigurationAdmin ca) {
        this.log = log;
        this.mts = mts;
        this.ca = ca;
    }

    public PreferenceOCD[] getLocalPrefOCDs(ServiceReference prefHolder) {
        String localPrefOCDID = this.getLocalPrefOCDID(prefHolder);
        return this.extractOCDs(prefHolder, localPrefOCDID);
    }

    public PreferenceOCD[] getGlobalPrefOCDs(ServiceReference prefHolder) {
        String globalPrefOCDID = this.getGlobalPrefOCDID(prefHolder);
        return this.extractOCDs(prefHolder, globalPrefOCDID);
    }

    public PreferenceOCD[] getParamPrefOCDs(ServiceReference prefHolder) {
        String paramPrefOCDID = this.getParamPrefOCDID(prefHolder);
        return this.extractParamOCDs(prefHolder, paramPrefOCDID);
    }

    private String getLocalPrefOCDID(ServiceReference prefHolder) {
        String localPrefOCDID = (String)prefHolder.getProperty("local_prefs_pid");
        if (localPrefOCDID != null) {
            return localPrefOCDID;
        }
        String defaultLocalPrefOCDID = String.valueOf((String)prefHolder.getProperty("service.pid")) + ".prefs.local";
        return defaultLocalPrefOCDID;
    }

    private String getGlobalPrefOCDID(ServiceReference prefHolder) {
        String globalPrefOCDID = (String)prefHolder.getProperty("global_prefs_pid");
        if (globalPrefOCDID != null) {
            return globalPrefOCDID;
        }
        String defaultGlobalPrefOCDID = String.valueOf((String)prefHolder.getProperty("service.pid")) + ".prefs.global";
        return defaultGlobalPrefOCDID;
    }

    private String getParamPrefOCDID(ServiceReference prefHolder) {
        String paramPrefOCDID = (String)prefHolder.getProperty("parameters_pid");
        if (paramPrefOCDID != null) {
            return paramPrefOCDID;
        }
        String defaultParamPrefOCDID = String.valueOf((String)prefHolder.getProperty("service.pid"));
        return defaultParamPrefOCDID;
    }

    private PreferenceOCD[] extractOCDs(ServiceReference prefHolder, String ocdID) {
        Bundle bundle = prefHolder.getBundle();
        MetaTypeInformation bundleMetaTypeInfo = this.mts.getMetaTypeInformation(bundle);
        ArrayList<PreferenceOCD> extractedOCDList = new ArrayList<PreferenceOCD>();
        PreferenceOCD extractedOCD = this.extractOCD(bundleMetaTypeInfo, ocdID);
        int ii = 2;
        while (extractedOCD != null) {
            extractedOCDList.add(extractedOCD);
            extractedOCD = this.extractOCD(bundleMetaTypeInfo, String.valueOf(ocdID) + ii);
            ++ii;
        }
        return extractedOCDList.toArray(new PreferenceOCD[extractedOCDList.size()]);
    }

    private PreferenceOCD extractOCD(MetaTypeInformation bundleMetaTypeInfo, String ocdID) {
        ObjectClassDefinition requestedOCD;
        block3: {
            try {
                requestedOCD = bundleMetaTypeInfo.getObjectClassDefinition(ocdID, null);
                if (requestedOCD != null) break block3;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        PreferenceOCDImpl wrappedOCD = new PreferenceOCDImpl(this.log, requestedOCD);
        return wrappedOCD;
    }

    private PreferenceOCD[] extractParamOCDs(ServiceReference prefHolder, String ocdID) {
        Bundle bundle = prefHolder.getBundle();
        MetaTypeInformation bundleMetaTypeInfo = this.mts.getMetaTypeInformation(bundle);
        PreferenceOCD paramOCD = this.extractOCD(bundleMetaTypeInfo, ocdID);
        if (paramOCD != null) {
            return new PreferenceOCD[]{paramOCD};
        }
        return new PreferenceOCD[0];
    }

    public Configuration[] getLocalPrefConfs(ServiceReference prefHolder, PreferenceOCD[] prefOCDs) {
        String localPrefConfID = this.getLocalPrefConfID(prefHolder);
        return this.extractConfs(localPrefConfID, prefOCDs);
    }

    public Configuration[] getGlobalPrefConfs(ServiceReference prefHolder, PreferenceOCD[] prefOCDs) {
        String globalPrefConfID = this.getGlobalPrefConfID(prefHolder);
        return this.extractConfs(globalPrefConfID, prefOCDs);
    }

    public Configuration[] getParamPrefConfs(ServiceReference prefHolder, PreferenceOCD[] prefOCDs) {
        String paramPrefConfID = this.getParamPrefConfID(prefHolder);
        return this.extractConfs(paramPrefConfID, prefOCDs);
    }

    public void ensurePrefsCanBeSentTo(ServiceReference serviceRef) {
        try {
            Configuration conf = this.ca.getConfiguration((String)serviceRef.getProperty("service.pid"), null);
            Dictionary properties = conf.getProperties();
            if (properties == null) {
                conf.update(new Hashtable());
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private Configuration[] extractConfs(String confPID, PreferenceOCD[] prefOCDs) {
        if (prefOCDs.length == 0) {
            return new Configuration[0];
        }
        ArrayList<Configuration> extractedConfList = new ArrayList<Configuration>();
        Configuration prefConf = this.extractConf(confPID);
        if (prefConf != null) {
            extractedConfList.add(prefConf);
            int ii = 2;
            while (ii < prefOCDs.length + 1) {
                prefConf = this.extractConf(String.valueOf(confPID) + ii);
                if (prefConf == null) break;
                extractedConfList.add(prefConf);
                ++ii;
            }
        }
        return extractedConfList.toArray(new Configuration[extractedConfList.size()]);
    }

    private Configuration extractConf(String confPID) {
        try {
            return this.ca.getConfiguration(confPID, null);
        }
        catch (IOException iOException) {
            this.log.log(1, "Unable to load configuration for " + confPID + " due to IO Error");
            return null;
        }
    }

    private String getLocalPrefConfID(ServiceReference prefHolder) {
        return (String)prefHolder.getProperty("service.pid");
    }

    private String getGlobalPrefConfID(ServiceReference prefHolder) {
        String globalPrefOCDID = (String)prefHolder.getProperty("global_prefs_pid");
        if (globalPrefOCDID != null) {
            return globalPrefOCDID;
        }
        String defaultGlobalPrefOCDID = String.valueOf((String)prefHolder.getProperty("service.pid")) + ".prefs.global";
        return defaultGlobalPrefOCDID;
    }

    private String getParamPrefConfID(ServiceReference prefHolder) {
        String paramPrefOCDID = (String)prefHolder.getProperty("parameters_pid");
        if (paramPrefOCDID != null) {
            return paramPrefOCDID;
        }
        String defaultGlobalPrefOCDID = String.valueOf((String)prefHolder.getProperty("service.pid")) + ".prefs.params";
        return defaultGlobalPrefOCDID;
    }
}

