/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.prefs.admin.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.cishell.reference.prefs.admin.PrefPage;
import org.cishell.reference.prefs.admin.PreferenceAD;
import org.cishell.reference.prefs.admin.PreferenceOCD;
import org.cishell.reference.prefs.admin.PrefsByService;
import org.cishell.reference.prefs.admin.internal.PrefInfoGrabber;
import org.cishell.reference.prefs.admin.internal.PrefPageImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.log.LogService;

public class PrefReferenceProcessor {
    private LogService log;
    private PrefInfoGrabber prefInfoGrabber;
    private List allLocalPrefPages = new ArrayList();
    private List allGlobalPrefPages = new ArrayList();
    private List allParamPrefPages = new ArrayList();
    private List allPrefsByService = new ArrayList();

    public PrefReferenceProcessor(LogService log, PrefInfoGrabber prefInfoGrabber) {
        this.log = log;
        this.prefInfoGrabber = prefInfoGrabber;
    }

    public void processPrefReferences(ServiceReference[] prefReferences) {
        int ii = 0;
        while (ii < prefReferences.length) {
            ServiceReference prefReference = prefReferences[ii];
            PrefPage[] localPrefPages = null;
            if (this.isTurnedOn(prefReference, "local")) {
                localPrefPages = this.getLocalPrefPages(prefReference);
                this.initializeConfigurations(localPrefPages);
                this.allLocalPrefPages.addAll(Arrays.asList(localPrefPages));
                this.warnIfReceivePrefsIsNotOn(prefReference);
            }
            PrefPage[] globalPrefPages = null;
            if (this.isTurnedOn(prefReference, "global")) {
                globalPrefPages = this.getGlobalPrefPages(prefReference);
                this.initializeConfigurations(globalPrefPages);
                this.allGlobalPrefPages.addAll(Arrays.asList(globalPrefPages));
            }
            PrefPage[] paramPrefPages = null;
            if (this.isTurnedOn(prefReference, "param-defaults")) {
                paramPrefPages = this.getParamPrefPages(prefReference);
                this.initializeConfigurations(paramPrefPages);
                this.allParamPrefPages.addAll(Arrays.asList(paramPrefPages));
            }
            PrefsByService allPrefsForThisService = new PrefsByService(prefReference, localPrefPages, globalPrefPages, paramPrefPages);
            this.allPrefsByService.add(allPrefsForThisService);
            if (this.isTurnedOn(prefReference, "receive_prefs")) {
                this.prefInfoGrabber.ensurePrefsCanBeSentTo(prefReference);
            }
            ++ii;
        }
    }

    public PrefPage[] getAllLocalPrefPages() {
        return this.getPrefPages(this.allLocalPrefPages);
    }

    public PrefPage[] getAllGlobalPrefPages() {
        return this.getPrefPages(this.allGlobalPrefPages);
    }

    public PrefPage[] getAllParamPrefPages() {
        return this.getPrefPages(this.allParamPrefPages);
    }

    public PrefsByService[] getAllPrefsByService() {
        return this.allPrefsByService.toArray(new PrefsByService[this.allPrefsByService.size()]);
    }

    private PrefPage[] getLocalPrefPages(ServiceReference prefHolder) {
        PreferenceOCD[] localPrefOCDs = this.prefInfoGrabber.getLocalPrefOCDs(prefHolder);
        Configuration[] localPrefConfs = this.prefInfoGrabber.getLocalPrefConfs(prefHolder, localPrefOCDs);
        PrefPage[] localPrefPages = this.composePrefPages(prefHolder, localPrefOCDs, localPrefConfs, 0);
        return localPrefPages;
    }

    private PrefPage[] getGlobalPrefPages(ServiceReference prefHolder) {
        PreferenceOCD[] globalPrefOCDs = this.prefInfoGrabber.getGlobalPrefOCDs(prefHolder);
        Configuration[] globalPrefConfs = this.prefInfoGrabber.getGlobalPrefConfs(prefHolder, globalPrefOCDs);
        PrefPage[] globalPrefPages = this.composePrefPages(prefHolder, globalPrefOCDs, globalPrefConfs, 1);
        return globalPrefPages;
    }

    private PrefPage[] getParamPrefPages(ServiceReference prefHolder) {
        PreferenceOCD[] paramPrefOCDs = this.prefInfoGrabber.getParamPrefOCDs(prefHolder);
        Configuration[] paramPrefConfs = this.prefInfoGrabber.getParamPrefConfs(prefHolder, paramPrefOCDs);
        PrefPage[] paramPrefPages = this.composePrefPages(prefHolder, paramPrefOCDs, paramPrefConfs, 2);
        return paramPrefPages;
    }

    private PrefPage[] composePrefPages(ServiceReference prefHolder, PreferenceOCD[] prefOCDs, Configuration[] prefConfs, int type) {
        int minLength = Math.min(prefOCDs.length, prefConfs.length);
        ArrayList<PrefPageImpl> composedPrefPageList = new ArrayList<PrefPageImpl>(prefOCDs.length);
        int ii = 0;
        while (ii < minLength) {
            PrefPageImpl composedPrefPage = new PrefPageImpl(prefHolder, prefOCDs[ii], prefConfs[ii], type);
            composedPrefPageList.add(composedPrefPage);
            ++ii;
        }
        return composedPrefPageList.toArray(new PrefPage[composedPrefPageList.size()]);
    }

    private void initializeConfiguration(PrefPage prefPage) {
        Configuration prefConf = prefPage.getPrefConf();
        Hashtable<String, String> prefDict = prefConf.getProperties();
        PreferenceOCD prefOCD = prefPage.getPrefOCD();
        if (prefDict == null || this.bundleHasBeenUpdated(prefPage)) {
            prefDict = new Hashtable<String, String>();
            PreferenceAD[] prefADs = prefOCD.getPreferenceAttributeDefinitions(-1);
            int ii = 0;
            while (ii < prefADs.length) {
                PreferenceAD prefAD = prefADs[ii];
                String id = prefAD.getID();
                String val = prefAD.getDefaultValue()[0];
                try {
                    ((Dictionary)prefDict).put(id, val);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ++ii;
            }
            ((Dictionary)prefDict).put("Bundle-Version", this.getCurrentBundleVersion(prefPage));
            try {
                prefConf.update(prefDict);
            }
            catch (IOException e) {
                this.log.log(1, "Unable to update configuration with PID " + prefConf.getPid(), (Throwable)e);
            }
        } else {
            try {
                prefConf.update(prefDict);
            }
            catch (IOException e) {
                this.log.log(1, "Unable to update configuration with PID " + prefConf.getPid(), (Throwable)e);
            }
        }
    }

    private void initializeConfigurations(PrefPage[] prefPages) {
        int ii = 0;
        while (ii < prefPages.length) {
            PrefPage prefPage = prefPages[ii];
            this.initializeConfiguration(prefPage);
            ++ii;
        }
    }

    private boolean isTurnedOn(ServiceReference prefReference, String processingKey) {
        if (processingKey.equals("receive_prefs")) {
            String receivePrefsValue = (String)prefReference.getProperty("receive_prefs");
            return receivePrefsValue != null && receivePrefsValue.equals("true");
        }
        String unparsedPublishedPrefsValues = (String)prefReference.getProperty("prefs_published");
        if (unparsedPublishedPrefsValues == null) {
            return false;
        }
        String[] publishedPrefsValues = unparsedPublishedPrefsValues.split(",");
        int ii = 0;
        while (ii < publishedPrefsValues.length) {
            if (publishedPrefsValues[ii].equals(processingKey)) {
                return true;
            }
            ++ii;
        }
        return publishedPrefsValues.length == 0 && processingKey == "param-defaults";
    }

    private boolean bundleHasBeenUpdated(PrefPage prefPage) {
        String currentBundleVersion = this.getCurrentBundleVersion(prefPage);
        String savedBundleVersion = this.getSavedBundleVersion(prefPage);
        if (savedBundleVersion == null) {
            return false;
        }
        if (currentBundleVersion.equals(savedBundleVersion)) {
            return false;
        }
        this.logBundleWasUpdated(prefPage);
        return true;
    }

    private String getCurrentBundleVersion(PrefPage prefPage) {
        Bundle b = prefPage.getServiceReference().getBundle();
        String currentBundleVersion = (String)b.getHeaders().get("Bundle-Version");
        return currentBundleVersion;
    }

    private String getSavedBundleVersion(PrefPage prefPage) {
        Dictionary prefDict = prefPage.getPrefConf().getProperties();
        if (prefDict == null) {
            return null;
        }
        String bundleVersionForLocalsAndParams = (String)prefDict.get("Bundle-Version");
        if (bundleVersionForLocalsAndParams != null) {
            return bundleVersionForLocalsAndParams;
        }
        String servicePID = (String)prefPage.getServiceReference().getProperty("service.pid");
        String bundleVersionForGlobals = (String)prefDict.get(String.valueOf(servicePID) + "." + "Bundle-Version");
        if (bundleVersionForGlobals != null) {
            return bundleVersionForGlobals;
        }
        return null;
    }

    private void logBundleWasUpdated(PrefPage prefPage) {
        String servicePID = (String)prefPage.getServiceReference().getProperty("service.pid");
        String prefOCDName = prefPage.getPrefOCD().getName();
        this.log.log(2, "The Bundle for the service " + servicePID + " was updated, so the preferences for " + prefOCDName + " will be set to the new defaults.");
    }

    private PrefPage[] getPrefPages(List prefPageList) {
        return prefPageList.toArray(new PrefPage[prefPageList.size()]);
    }

    private void warnIfReceivePrefsIsNotOn(ServiceReference prefHolder) {
        if (!this.isTurnedOn(prefHolder, "receive_prefs")) {
            String servicePID = (String)prefHolder.getProperty("service.pid");
            this.log.log(2, "Algorithm Developer Error: \r\nThe algorithm " + servicePID + " has published local preferences without requested to receive preferences. \r\n" + "  Algorithms that want to see preferences (both local and global) " + "need to set receive_prefs=true in their .properties file, but since there is no purpose in defining local preferences " + "without being able to receive preferences, we will turn it on for you. You must also implement the ManagedService" + "interface for the AlgorithmFactory if you have not already done so.");
        }
    }
}

