/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.prefs.admin.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.cishell.reference.prefs.admin.PreferenceAD;
import org.cishell.reference.prefs.admin.internal.TypePrefixes;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;

public class PreferenceADImpl
implements AttributeDefinition,
PreferenceAD {
    private static final String URI_FILE_PREFIX = "file:";
    private LogService log;
    private AttributeDefinition realAD;
    private int preferenceType;
    private String[] interpretedDefaultValue;
    private String platformIndepInstallDirPath;

    public PreferenceADImpl(LogService log, AttributeDefinition realAD) {
        this.log = log;
        this.realAD = realAD;
        this.preferenceType = this.inferPreferenceType(realAD);
        this.platformIndepInstallDirPath = this.generateIndepInstallDirPath();
        this.interpretedDefaultValue = this.interpretDefaultValue(this.realAD.getDefaultValue());
    }

    private int inferPreferenceType(AttributeDefinition realAD) {
        String defaultVal;
        int preferenceType = realAD.getType() != 19 ? ((defaultVal = realAD.getDefaultValue()[0]).startsWith("directory:") ? 20 : (defaultVal.startsWith(URI_FILE_PREFIX) ? 21 : (defaultVal.startsWith("font:") ? 22 : (defaultVal.startsWith("path:") ? 23 : (realAD.getOptionLabels() != null ? 24 : (defaultVal.startsWith("color:") ? 25 : 19)))))) : realAD.getType();
        return preferenceType;
    }

    @Override
    public int getCardinality() {
        return this.realAD.getCardinality();
    }

    @Override
    public String[] getDefaultValue() {
        return this.interpretedDefaultValue;
    }

    private String generateIndepInstallDirPath() {
        String installDirPath = System.getProperty("osgi.install.area").replace(URI_FILE_PREFIX, "");
        File installDirFile = new File(installDirPath);
        URI platformIndependentFile = installDirFile.toURI();
        String platformIndepInstallDirPath = platformIndependentFile.toString();
        return platformIndepInstallDirPath;
    }

    private String[] interpretDefaultValue(String[] rawDefaultValues) {
        String[] interpretedDefaultValues = new String[rawDefaultValues.length];
        int i = 0;
        while (i < rawDefaultValues.length) {
            String rawDefaultValue = rawDefaultValues[i];
            interpretedDefaultValues[i] = this.interpretDefaultValue(rawDefaultValue);
            ++i;
        }
        return interpretedDefaultValues;
    }

    private String interpretDefaultValue(String rawDefaultValue) {
        int preferenceType = this.getPreferenceType();
        if (preferenceType == 20) {
            String uriFormattedDefaultValue = rawDefaultValue.replace("directory:", URI_FILE_PREFIX);
            return this.makePlatformSpecificPath(uriFormattedDefaultValue);
        }
        if (preferenceType == 21) {
            if (rawDefaultValue.equals(URI_FILE_PREFIX)) {
                return "";
            }
            String uriFormattedDefaultValue = rawDefaultValue;
            return this.makePlatformSpecificPath(uriFormattedDefaultValue);
        }
        if (preferenceType == 22) {
            return rawDefaultValue.replace("font:", "");
        }
        if (preferenceType == 23) {
            return rawDefaultValue.replace("path:", "");
        }
        if (preferenceType == 19) {
            return rawDefaultValue;
        }
        if (preferenceType == 25) {
            return rawDefaultValue.replace("color:", "");
        }
        return rawDefaultValue;
    }

    private String makePlatformSpecificPath(String platformIndependentPath) {
        if (!platformIndependentPath.startsWith("file:/")) {
            platformIndependentPath = String.valueOf(this.platformIndepInstallDirPath) + platformIndependentPath.replace(URI_FILE_PREFIX, "");
        }
        try {
            URI uriInterpretation = new URI(platformIndependentPath);
            File platformSpecificInterpretation = new File(uriInterpretation);
            String platformSpecificDirectory = platformSpecificInterpretation.getAbsolutePath();
            return platformSpecificDirectory;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.log.log(2, "Invalid syntax  in preference AD " + this.realAD.getName());
            return System.getProperty("osgi.install.area").replace(URI_FILE_PREFIX, "");
        }
    }

    @Override
    public String getDescription() {
        return this.realAD.getDescription();
    }

    @Override
    public String getID() {
        return this.realAD.getID();
    }

    @Override
    public String getName() {
        return this.realAD.getName();
    }

    @Override
    public String[] getOptionLabels() {
        return this.realAD.getOptionLabels();
    }

    @Override
    public String[] getOptionValues() {
        return this.realAD.getOptionValues();
    }

    @Override
    public int getType() {
        return this.realAD.getType();
    }

    @Override
    public int getPreferenceType() {
        return this.preferenceType;
    }

    @Override
    public String getPreferenceTypePrefix() {
        return TypePrefixes.getPrefPrefixFromPrefTypeID(new Integer(this.getPreferenceType()));
    }

    @Override
    public String validate(String value) {
        return this.realAD.validate(value);
    }
}

