/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.prefs.admin.internal;

import java.io.IOException;
import java.io.InputStream;
import org.cishell.reference.prefs.admin.PreferenceAD;
import org.cishell.reference.prefs.admin.PreferenceOCD;
import org.cishell.reference.prefs.admin.internal.PreferenceADImpl;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class PreferenceOCDImpl
implements ObjectClassDefinition,
PreferenceOCD {
    private ObjectClassDefinition realOCD;
    private PreferenceAD[] allWrappedADs;
    private PreferenceAD[] optionalWrappedADs;
    private PreferenceAD[] requiredWrappedADs;
    private LogService log;

    public PreferenceOCDImpl(LogService log, ObjectClassDefinition realOCD) {
        this.log = log;
        this.realOCD = realOCD;
        this.allWrappedADs = this.wrapAttributeDefinitions(realOCD.getAttributeDefinitions(-1));
        this.optionalWrappedADs = this.wrapAttributeDefinitions(realOCD.getAttributeDefinitions(2));
        this.requiredWrappedADs = this.wrapAttributeDefinitions(realOCD.getAttributeDefinitions(1));
    }

    private PreferenceAD[] wrapAttributeDefinitions(AttributeDefinition[] realAttributeDefinitions) {
        PreferenceAD[] wrappedADs = new PreferenceAD[realAttributeDefinitions.length];
        int i = 0;
        while (i < realAttributeDefinitions.length) {
            AttributeDefinition realAD = realAttributeDefinitions[i];
            PreferenceADImpl wrappedAD = new PreferenceADImpl(this.log, realAD);
            wrappedADs[i] = wrappedAD;
            ++i;
        }
        return wrappedADs;
    }

    @Override
    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        return this.realOCD.getAttributeDefinitions(filter);
    }

    @Override
    public PreferenceAD[] getPreferenceAttributeDefinitions(int filter) {
        if (filter == -1) {
            return this.allWrappedADs;
        }
        if (filter == 2) {
            return this.optionalWrappedADs;
        }
        if (filter == 1) {
            return this.requiredWrappedADs;
        }
        this.log.log(2, "Programmer Error: attempted to get preference attribute definitions with invalid filter " + filter);
        return new PreferenceAD[0];
    }

    @Override
    public String getDescription() {
        return this.realOCD.getDescription();
    }

    @Override
    public String getID() {
        return this.realOCD.getID();
    }

    @Override
    public InputStream getIcon(int size) throws IOException {
        return this.realOCD.getIcon(size);
    }

    @Override
    public String getName() {
        return this.realOCD.getName();
    }

    @Override
    public PreferenceAD getAttributeByID(String attributeID) {
        PreferenceAD adWeAreLookingFor = null;
        PreferenceAD[] ads = this.getPreferenceAttributeDefinitions(-1);
        int ii = 0;
        while (ii < ads.length) {
            PreferenceAD ad = ads[ii];
            if (ad.getID().equals(attributeID)) {
                adWeAreLookingFor = ad;
                break;
            }
            ++ii;
        }
        if (adWeAreLookingFor != null) {
            return adWeAreLookingFor;
        }
        return null;
    }
}

