/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.service.database;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.cishell.reference.service.database.ExternalDatabase;
import org.cishell.reference.service.database.InternalDerbyDatabase;
import org.cishell.reference.service.database.utility.DatabaseCleaner;
import org.cishell.service.database.Database;
import org.cishell.service.database.DatabaseCopyException;
import org.cishell.service.database.DatabaseCreationException;
import org.cishell.service.database.DatabaseService;
import org.cishell.utilities.DatabaseUtilities;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DerbyDatabaseService
implements DatabaseService,
BundleActivator {
    public static final String DERBY_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DERBY_PROTOCOL = "jdbc:derby:";
    public static final String DEFAULT_CREATE_CONNECTION_STRING = ";create=true";
    public static final String DEFAULT_SHUTDOWN_CONNECTION_STRING = ";shutdown=true";
    private static final String DATABASE_DIRECTORY = "database/";
    private ServiceRegistration databaseServiceRegistration;
    private List<InternalDerbyDatabase> internalDatabases = new ArrayList<InternalDerbyDatabase>();
    private static final String INTERNAL_DB_NAME_PREFIX = "cishell_database";
    private static int id = 0;

    public final void start(BundleContext context) throws Exception {
        System.setProperty("derby.system.home", DATABASE_DIRECTORY);
        this.databaseServiceRegistration = context.registerService(DatabaseService.class.getName(), (Object)this, new Hashtable());
    }

    public final void stop(BundleContext context) {
        this.databaseServiceRegistration.unregister();
        try {
            for (InternalDerbyDatabase internalDatabase : this.internalDatabases) {
                internalDatabase.getConnection();
                internalDatabase.shutdown();
            }
        }
        catch (Exception e) {
            String message = "An unexpected exception occurred while shutting down the internal database.Aborting database shutdown process.Database may not be left in a valid state, but we will try to make its state valid on next startup.";
            throw new RuntimeException(message, e);
        }
    }

    public Database createNewDatabase() throws DatabaseCreationException {
        String databaseName = this.nextDatabaseIdentifier();
        DataSource internalDataSource = this.createNewInternalDataSource(databaseName);
        InternalDerbyDatabase internalDatabase = this.createNewInternalDatabase(internalDataSource);
        internalDatabase.setName(databaseName);
        return internalDatabase;
    }

    public Database connectToExistingDatabase(String driver, String url) throws DatabaseCreationException {
        return this.connectToExistingDatabase(driver, url, null, null);
    }

    public Database connectToExistingDatabase(String driver, String url, String username, String password) throws DatabaseCreationException {
        DataSource dataSource = this.createNewDataSource(driver, url, username, password);
        ExternalDatabase db = new ExternalDatabase(dataSource, "APP");
        return db;
    }

    public Database copyDatabase(Database originalDatabase) throws DatabaseCopyException {
        if (originalDatabase instanceof InternalDerbyDatabase) {
            InternalDerbyDatabase database = (InternalDerbyDatabase)originalDatabase;
            String originalName = database.getName();
            Connection connection = null;
            try {
                InternalDerbyDatabase internalDatabase;
                connection = database.getConnection();
                String backupLocation = this.createDatabaseBackup(connection, originalName);
                InternalDerbyDatabase internalDerbyDatabase = internalDatabase = this.createInternalDatabaseFromBackup(backupLocation);
                return internalDerbyDatabase;
            }
            catch (SQLException e) {
                throw new DatabaseCopyException("A problem occurred while attempting to copy the database.", (Throwable)e);
            }
            catch (DatabaseCreationException e) {
                throw new DatabaseCopyException("A problem occurred while attempting to copy the database.", (Throwable)e);
            }
            finally {
                DatabaseUtilities.closeConnectionQuietly((Connection)connection);
            }
        }
        throw new DatabaseCopyException("Unable to copy external databases!");
    }

    private InternalDerbyDatabase createInternalDatabaseFromBackup(String backupLocation) throws DatabaseCreationException {
        String newName = this.nextDatabaseIdentifier();
        String newDatabaseConnectionURL = DERBY_PROTOCOL + newName + ";restoreFrom=" + backupLocation;
        DataSource derivedDataSource = this.createNewDataSource(DERBY_DRIVER_NAME, newDatabaseConnectionURL, null, null);
        InternalDerbyDatabase internalDatabase = this.createNewInternalDatabase(derivedDataSource, false);
        internalDatabase.setName(newName);
        return internalDatabase;
    }

    private String createDatabaseBackup(Connection connection, String originalName) throws SQLException {
        CallableStatement backupStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        String tempDir = System.getProperty("java.io.tmpdir");
        backupStatement.setString(1, tempDir);
        backupStatement.execute();
        String backupLocation = new File(new File(tempDir), originalName).getAbsolutePath();
        return backupLocation;
    }

    private DataSource createNewDataSource(String driver, String url, String username, String password) throws DatabaseCreationException {
        try {
            Class.forName(driver);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, username, password);
            GenericObjectPool connectionPool = new GenericObjectPool();
            GenericKeyedObjectPoolFactory stmtPool = new GenericKeyedObjectPoolFactory(null);
            new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, (KeyedObjectPoolFactory)stmtPool, null, false, true);
            PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
            dataSource.getConnection();
            return dataSource;
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseCreationException("Database driver '" + driver + "' could not be found", (Throwable)e);
        }
        catch (SQLException e) {
            throw new DatabaseCreationException(e.getMessage(), (Throwable)e);
        }
    }

    private DataSource createNewInternalDataSource(String dbName) throws DatabaseCreationException {
        String newDatabaseConnectionURL = DERBY_PROTOCOL + dbName + DEFAULT_CREATE_CONNECTION_STRING;
        return this.createNewDataSource(DERBY_DRIVER_NAME, newDatabaseConnectionURL, null, null);
    }

    private InternalDerbyDatabase createNewInternalDatabase(DataSource internalDataSource) throws DatabaseCreationException {
        return this.createNewInternalDatabase(internalDataSource, true);
    }

    private InternalDerbyDatabase createNewInternalDatabase(DataSource internalDataSource, boolean clean) throws DatabaseCreationException {
        InternalDerbyDatabase db = new InternalDerbyDatabase(internalDataSource);
        Connection cleaningConnection = null;
        try {
            if (clean) {
                cleaningConnection = db.getConnection();
                DatabaseCleaner.cleanDatabase(cleaningConnection, false);
            }
            this.internalDatabases.add(db);
            return db;
        }
        catch (Exception e) {
            DatabaseUtilities.closeConnectionQuietly(cleaningConnection);
            throw new DatabaseCreationException((Throwable)e);
        }
    }

    private synchronized String nextDatabaseIdentifier() {
        String randomPart = UUID.randomUUID().toString();
        String identifier = INTERNAL_DB_NAME_PREFIX + randomPart + "_" + id;
        ++id;
        return identifier;
    }
}

