/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.service.database.utility;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.cishell.reference.service.database.utility.JDBC;

public class DatabaseCleaner {
    private static final String[] CLEAR_DB_PROPERTIES = new String[]{"derby.database.classpath"};
    private static final String[] COMPRESS_DB_OBJECTS = new String[]{"SYS.SYSDEPENDS"};

    public static void cleanDatabase(Connection conn, boolean compress) throws SQLException {
        DatabaseCleaner.clearProperties(conn);
        DatabaseCleaner.removeObjects(conn);
        if (compress) {
            DatabaseCleaner.compressObjects(conn);
        }
    }

    private static void clearProperties(Connection conn) throws SQLException {
        CallableStatement ps = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, NULL)");
        int i = 0;
        while (i < CLEAR_DB_PROPERTIES.length) {
            ps.setString(1, CLEAR_DB_PROPERTIES[i]);
            ps.executeUpdate();
            ++i;
        }
        ps.close();
        conn.commit();
    }

    private static void removeObjects(Connection conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        SQLException sqle = null;
        int count = 0;
        while (count < 5) {
            ArrayList<String> schemas = new ArrayList<String>();
            ResultSet rs = dmd.getSchemas();
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                if (schema.startsWith("SYS") || schema.equals("SQLJ") || schema.equals("NULLID")) continue;
                schemas.add(schema);
            }
            rs.close();
            sqle = null;
            for (String schema : schemas) {
                try {
                    JDBC.dropSchema(dmd, schema);
                }
                catch (SQLException e) {
                    sqle = e;
                }
            }
            if (sqle == null) {
                return;
            }
            ++count;
        }
        throw sqle;
    }

    private static void removeRoles(Connection conn) throws SQLException {
        Statement stm = conn.createStatement();
        Statement dropStm = conn.createStatement();
        ResultSet rs = stm.executeQuery("select roleid from sys.sysroles where cast(isdef as char(1)) = 'Y'");
        while (rs.next()) {
            dropStm.executeUpdate("DROP ROLE " + JDBC.escape(rs.getString(1)));
        }
        stm.close();
        dropStm.close();
        conn.commit();
    }

    private static void compressObjects(Connection conn) throws SQLException {
        CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        int i = 0;
        while (i < COMPRESS_DB_OBJECTS.length) {
            int delim = COMPRESS_DB_OBJECTS[i].indexOf(".");
            cs.setString(1, COMPRESS_DB_OBJECTS[i].substring(0, delim));
            cs.setString(2, COMPRESS_DB_OBJECTS[i].substring(delim + 1));
            cs.execute();
            ++i;
        }
        cs.close();
        conn.commit();
    }
}

