/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.service.database.utility;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;

public class JDBC {
    public static final String[] GET_TABLES_TABLE = new String[]{"TABLE"};
    public static final String[] GET_TABLES_VIEW = new String[]{"VIEW"};
    public static final String[] GET_TABLES_SYNONYM = new String[]{"SYNONYM"};
    public static final int SQLXML = 2009;
    private static final boolean HAVE_DRIVER = JDBC.haveClass("java.sql.Driver");
    private static final boolean HAVE_SAVEPOINT = JDBC.haveClass("java.sql.Savepoint");
    private static final boolean HAVE_SQLXML = JDBC.haveClass("java.sql.SQLXML");

    static boolean haveClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean vmSupportsJDBC4() {
        return HAVE_DRIVER && HAVE_SQLXML;
    }

    public static boolean vmSupportsJDBC3() {
        return HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static boolean vmSupportsJSR169() {
        return !HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static void cleanup(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        if (conn.isClosed()) {
            return;
        }
        SQLException sqle = null;
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            sqle = e;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            if (sqle == null) {
                sqle = e;
            } else {
                sqle.setNextException(e);
            }
            throw sqle;
        }
    }

    public static void dropSchema(DatabaseMetaData dmd, String schema) throws SQLException {
        Connection conn = dmd.getConnection();
        Statement s = dmd.getConnection().createStatement();
        PreparedStatement psf = conn.prepareStatement("SELECT ALIAS FROM SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID  AND CHAR(A.ALIASTYPE) = ?  AND S.SCHEMANAME = ?");
        psf.setString(1, "F");
        psf.setString(2, schema);
        ResultSet rs = psf.executeQuery();
        JDBC.dropUsingDMD(s, rs, schema, "ALIAS", "FUNCTION");
        rs = dmd.getProcedures(null, schema, null);
        JDBC.dropUsingDMD(s, rs, schema, "PROCEDURE_NAME", "PROCEDURE");
        rs = dmd.getTables(null, schema, null, GET_TABLES_VIEW);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "VIEW");
        rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "TABLE");
        ResultSet table_rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
        while (table_rs.next()) {
            String tablename = table_rs.getString("TABLE_NAME");
            rs = dmd.getExportedKeys(null, schema, tablename);
            while (rs.next()) {
                String fkName;
                short keyPosition = rs.getShort("KEY_SEQ");
                if (keyPosition != 1 || (fkName = rs.getString("FK_NAME")) == null) continue;
                String fkSchema = rs.getString("FKTABLE_SCHEM");
                String fkTable = rs.getString("FKTABLE_NAME");
                String ddl = "ALTER TABLE " + JDBC.escape(fkSchema, fkTable) + " DROP FOREIGN KEY " + JDBC.escape(fkName);
                s.executeUpdate(ddl);
            }
            rs.close();
        }
        table_rs.close();
        conn.commit();
        rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "TABLE");
        psf.setString(1, "A");
        psf.setString(2, schema);
        rs = psf.executeQuery();
        JDBC.dropUsingDMD(s, rs, schema, "ALIAS", "TYPE");
        psf.close();
        rs = dmd.getTables(null, schema, null, GET_TABLES_SYNONYM);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "SYNONYM");
        if (JDBC.sysSequencesExists(conn)) {
            psf = conn.prepareStatement("SELECT SEQUENCENAME FROM SYS.SYSSEQUENCES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID  AND S.SCHEMANAME = ?");
            psf.setString(1, schema);
            rs = psf.executeQuery();
            JDBC.dropUsingDMD(s, rs, schema, "SEQUENCENAME", "SEQUENCE");
            psf.close();
        }
        if (!schema.equals("APP")) {
            s.executeUpdate("DROP SCHEMA " + JDBC.escape(schema) + " RESTRICT");
        }
        conn.commit();
        s.close();
    }

    private static boolean sysSequencesExists(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("select count(*) from sys.systables t, sys.sysschemas s\nwhere t.schemaid = s.schemaid\nand ( cast(s.schemaname as varchar(128)))= 'SYS'\nand ( cast(t.tablename as varchar(128))) = 'SYSSEQUENCES'");
            rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void dropUsingDMD(Statement s, ResultSet rs, String schema, String mdColumn, String dropType) throws SQLException {
        boolean bl;
        int[] results;
        String dropLeadIn = "DROP " + dropType + " ";
        ArrayList<void> ddl = new ArrayList<void>();
        while (rs.next()) {
            void var8_8;
            String objectName = rs.getString(mdColumn);
            String string = String.valueOf(dropLeadIn) + JDBC.escape(schema, objectName);
            if ("TYPE".equals(dropType)) {
                String string2 = String.valueOf(string) + " restrict ";
            }
            ddl.add(var8_8);
        }
        rs.close();
        if (ddl.isEmpty()) {
            return;
        }
        s.clearBatch();
        for (Object e : ddl) {
            if (e == null) continue;
            s.addBatch(e.toString());
        }
        try {
            results = s.executeBatch();
            boolean bl2 = false;
        }
        catch (BatchUpdateException batchException) {
            results = batchException.getUpdateCounts();
            boolean bl3 = true;
        }
        boolean didDrop = false;
        int i = 0;
        while (i < results.length) {
            int result = results[i];
            if (result == -3) {
                bl = true;
            } else if (result == -2 || result >= 0) {
                didDrop = true;
                ddl.set(i, (void)null);
            }
            ++i;
        }
        s.clearBatch();
        if (didDrop) {
            s.getConnection().commit();
        }
        if (bl) {
            boolean bl4;
            do {
                bl4 = false;
                didDrop = false;
                ListIterator i2 = ddl.listIterator();
                while (i2.hasNext()) {
                    Object sql = i2.next();
                    if (sql == null) continue;
                    try {
                        s.executeUpdate(sql.toString());
                        i2.set(null);
                        didDrop = true;
                    }
                    catch (SQLException sQLException) {
                        bl4 = true;
                    }
                }
                if (!didDrop) continue;
                s.getConnection().commit();
            } while (bl4 && didDrop);
        }
    }

    private static String bytesToString(byte[] ba) {
        if (ba == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < ba.length) {
            s.append(Integer.toHexString(ba[i] & 0xFF));
            ++i;
        }
        return s.toString();
    }

    public static String escape(String name) {
        StringBuffer buffer = new StringBuffer(name.length() + 2);
        buffer.append('\"');
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '\"') {
                buffer.append('\"');
            }
            buffer.append(c);
            ++i;
        }
        buffer.append('\"');
        return buffer.toString();
    }

    private static String compressQuotes(String source, String quotes) {
        String result = source;
        int index = result.indexOf(quotes);
        while (index != -1) {
            result = String.valueOf(result.substring(0, index + 1)) + result.substring(index + 2);
            index = result.indexOf(quotes, index + 1);
        }
        return result;
    }

    public static String identifierToCNF(String id) {
        if (id == null || id.length() == 0) {
            return id;
        }
        if (id.charAt(0) == '\"' && id.length() >= 3 && id.charAt(id.length() - 1) == '\"') {
            return JDBC.compressQuotes(id.substring(1, id.length() - 1), "\"\"");
        }
        return id.toUpperCase(Locale.ENGLISH);
    }

    public static String escape(String schema, String name) {
        return String.valueOf(JDBC.escape(schema)) + "." + JDBC.escape(name);
    }

    public static String sqlNameFromJdbc(int jdbcType) {
        switch (jdbcType) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "CHAR () FOR BIT DATA";
            }
            case -3: {
                return "VARCHAR () FOR BIT DATA";
            }
            case -4: {
                return "LONG VARCHAR FOR BIT DATA";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(jdbcType);
    }
}

