/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.datamanager;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.cishell.app.service.datamanager.DataManagerListener;
import org.cishell.app.service.datamanager.DataManagerService;
import org.cishell.framework.data.Data;

public class DataManagerServiceImpl
implements DataManagerService {
    private Map<Data, String> datumToLabel = new LinkedHashMap<Data, String>();
    private Map<String, Data> labelToDatum = new LinkedHashMap<String, Data>();
    private Map<String, Integer> labelToOccurrenceCount = new LinkedHashMap<String, Integer>();
    private Set<Data> data = new LinkedHashSet<Data>();
    private Set<Data> selectedData = new LinkedHashSet<Data>();
    private Set<DataManagerListener> listeners = new LinkedHashSet<DataManagerListener>();

    public void addData(Data datum) {
        if (datum == null) {
            return;
        }
        String label = (String)datum.getMetadata().get("Label");
        String type = (String)datum.getMetadata().get("Type");
        if (type == null) {
            type = "Unknown";
            datum.getMetadata().put("Type", type);
        }
        if (label == null || "".equals(label)) {
            label = this.generateDefaultLabel(type);
        }
        this.addModel(datum, label);
        for (DataManagerListener listener : this.listeners) {
            listener.dataAdded(datum, label);
        }
    }

    private void addModel(Data datum, String label) {
        label = this.findUniqueLabel(label);
        datum.getMetadata().put("Label", label);
        datum.getMetadata().put("Modified", new Boolean(true));
        this.datumToLabel.put(datum, label);
        this.labelToDatum.put(label, datum);
        this.data.add(datum);
    }

    private String generateDefaultLabel(String dataType) {
        String label;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (stack.length > 2) {
            String className = stack[2].getClassName();
            int lastDot = className.lastIndexOf(".");
            if (className.length() > lastDot) {
                if ((className = className.substring(++lastDot)).endsWith("Algorithm")) {
                    className = className.substring(0, className.lastIndexOf("Algorithm"));
                }
                if (className.endsWith("Factory")) {
                    className = className.substring(0, className.lastIndexOf("Factory"));
                }
            }
            label = className;
        } else {
            label = "Unknown";
        }
        return String.format("%s.%s", label, dataType);
    }

    private String findUniqueLabel(String label) {
        Integer occurenceCount = this.labelToOccurrenceCount.get(label);
        if (occurenceCount == null) {
            this.labelToOccurrenceCount.put(label, new Integer(1));
            return label;
        }
        int numOccurrencesVal = occurenceCount;
        int newNumOccurrencesVal = numOccurrencesVal + 1;
        String newLabel = String.valueOf(label) + "." + newNumOccurrencesVal;
        while (this.getModelForLabel(newLabel) != null) {
            newLabel = String.valueOf(label) + "." + ++newNumOccurrencesVal;
        }
        this.labelToOccurrenceCount.put(label, new Integer(newNumOccurrencesVal));
        this.labelToOccurrenceCount.put(newLabel, new Integer(1));
        return newLabel;
    }

    public void removeData(Data datum) {
        String label = this.getLabel(datum);
        this.labelToDatum.remove(label);
        this.datumToLabel.remove(datum);
        this.labelToOccurrenceCount.remove(label);
        this.data.remove(datum);
        for (DataManagerListener listener : this.listeners) {
            listener.dataRemoved(datum);
        }
    }

    public Data[] getSelectedData() {
        return this.selectedData.toArray(new Data[0]);
    }

    public void setSelectedData(Data[] data) {
        this.selectedData.clear();
        this.selectedData.addAll(Arrays.asList(data));
        int ii = 0;
        while (ii < data.length) {
            if (!this.data.contains(data[ii])) {
                this.addData(data[ii]);
            }
            ++ii;
        }
        for (DataManagerListener listener : this.listeners) {
            listener.dataSelected(data);
        }
    }

    private Data getModelForLabel(String label) {
        return this.labelToDatum.get(label);
    }

    public String getLabel(Data datum) {
        return this.datumToLabel.get(datum);
    }

    public synchronized void setLabel(Data datum, String label) {
        String uniqueLabel = this.findUniqueLabel(label);
        this.datumToLabel.put(datum, uniqueLabel);
        this.labelToDatum.put(uniqueLabel, datum);
        for (DataManagerListener listener : this.listeners) {
            listener.dataLabelChanged(datum, label);
        }
    }

    public Data[] getAllData() {
        return this.data.toArray(new Data[0]);
    }

    public void addDataManagerListener(DataManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeDataManagerListener(DataManagerListener listener) {
        this.listeners.remove(listener);
    }
}

