/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.fileloader;

import java.io.File;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.reference.app.service.persistence.AbstractDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FileFormatSelector
extends AbstractDialog {
    private BundleContext bundleContext;
    private AlgorithmFactory validator;
    private ServiceReference[] validatorReferences;
    private List validatorList;

    public FileFormatSelector(String title, Shell parent, BundleContext bundleContext, ServiceReference[] validatorReferences, File file) {
        super(parent, title, AbstractDialog.QUESTION);
        this.bundleContext = bundleContext;
        this.validatorReferences = validatorReferences;
        String descriptionFormat = "The file '%s' can be loaded using one or more of the following formats.%nPlease select the format you would like to try.";
        this.setDescription(String.format(descriptionFormat, file.getAbsolutePath()));
        this.setDetails("This dialog allows the user to choose among all available formats for loading the selected data model.  Choose any of the formats to continue loading the dataset.");
    }

    public AlgorithmFactory getValidator() {
        return this.validator;
    }

    private Composite initializeGUI(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        Group validatorGroup = new Group(content, 0);
        validatorGroup.setText("Load as...");
        validatorGroup.setLayout((Layout)new FillLayout());
        GridData validatorListGridData = new GridData(1808);
        validatorListGridData.widthHint = 200;
        validatorGroup.setLayoutData((Object)validatorListGridData);
        this.validatorList = new List((Composite)validatorGroup, 772);
        this.initializePersisterList();
        this.validatorList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                List list = (List)mouseEvent.getSource();
                int selection = list.getSelectionIndex();
                if (selection != -1) {
                    FileFormatSelector.this.selectionMade(selection);
                }
            }
        });
        this.validatorList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List list = (List)selectionEvent.getSource();
                int selection = list.getSelectionIndex();
            }
        });
        this.validatorList.setSelection(0);
        return content;
    }

    private void initializePersisterList() {
        int ii = 0;
        while (ii < this.validatorReferences.length) {
            String name = (String)this.validatorReferences[ii].getProperty("label");
            if (name == null || name.length() == 0) {
                name = this.validatorReferences[ii].getClass().getName();
            }
            this.validatorList.add(name);
            ++ii;
        }
    }

    private void selectionMade(int selectedIndex) {
        this.validator = (AlgorithmFactory)this.bundleContext.getService(this.validatorReferences[selectedIndex]);
        this.close(true);
    }

    @Override
    public void createDialogButtons(Composite parent) {
        Button select = new Button(parent, 8);
        select.setText("Select");
        select.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int index = FileFormatSelector.this.validatorList.getSelectionIndex();
                if (index != -1) {
                    FileFormatSelector.this.selectionMade(index);
                }
            }
        });
        select.setFocus();
        Button cancel = new Button(parent, 0);
        cancel.setText("Cancel");
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileFormatSelector.this.close(false);
            }
        });
    }

    @Override
    public Composite createContent(Composite parent) {
        return this.initializeGUI(parent);
    }
}

