/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.fileloader;

import java.io.File;
import org.cishell.reference.app.service.fileloader.FileLoaderServiceImpl;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

public final class FileSelectorRunnable
implements Runnable {
    private IWorkbenchWindow window;
    private boolean selectSingleFile;
    private String[] filterExtensions;
    private File[] files;

    public FileSelectorRunnable(IWorkbenchWindow window, boolean selectSingleFile, String[] filterExtensions) {
        this.window = window;
        this.selectSingleFile = selectSingleFile;
        this.filterExtensions = filterExtensions;
    }

    public File[] getFiles() {
        return this.files;
    }

    @Override
    public void run() {
        this.files = this.getFilesFromUser();
        if (this.files.length == 0) {
            return;
        }
        FileLoaderServiceImpl.defaultLoadDirectory = this.files[0].getParentFile().getAbsolutePath();
    }

    private File[] getFilesFromUser() {
        FileDialog fileDialog = this.createFileDialog();
        fileDialog.open();
        String path = fileDialog.getFilterPath();
        String[] fileNames = fileDialog.getFileNames();
        if (fileNames == null || fileNames.length == 0) {
            return new File[0];
        }
        File[] files = new File[fileNames.length];
        int ii = 0;
        while (ii < fileNames.length) {
            String fullFileName = String.valueOf(path) + File.separator + fileNames[ii];
            files[ii] = new File(fullFileName);
            ++ii;
        }
        return files;
    }

    private FileDialog createFileDialog() {
        File currentDirectory = new File(FileLoaderServiceImpl.defaultLoadDirectory);
        String absolutePath = currentDirectory.getAbsolutePath();
        FileDialog fileDialog = new FileDialog(this.window.getShell(), 0x1000 | this.determineSWTFileSelectFlag());
        fileDialog.setFilterPath(absolutePath);
        if (this.filterExtensions != null && this.filterExtensions.length > 0) {
            fileDialog.setFilterExtensions(this.filterExtensions);
        }
        fileDialog.setText("Select Files");
        return fileDialog;
    }

    private int determineSWTFileSelectFlag() {
        if (this.selectSingleFile) {
            return 4;
        }
        return 2;
    }
}

