/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.fileloader;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class PrettyLabeler {
    public static Data[] relabelWithFileName(Data[] data, File file) {
        File absoluteFile = file.getAbsoluteFile();
        File parent = absoluteFile.getParentFile();
        String parentName = parent.getName();
        String prefix = parentName.trim().length() == 0 ? File.separator : "..." + File.separator + parentName + File.separator;
        ArrayList<BasicData> newData = new ArrayList<BasicData>(data.length);
        Data[] dataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Data datum = dataArray[n2];
            Dictionary originalDatumMetadata = datum.getMetadata();
            Hashtable labeledDatumMetadata = new Hashtable();
            Enumeration keys = originalDatumMetadata.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                ((Dictionary)labeledDatumMetadata).put(key, originalDatumMetadata.get(key));
            }
            BasicData labeledDatum = new BasicData(labeledDatumMetadata, datum.getData(), datum.getFormat());
            ((Dictionary)labeledDatumMetadata).put("Label", String.valueOf(prefix) + absoluteFile.getName());
            newData.add(labeledDatum);
            ++n2;
        }
        return newData.toArray(new Data[0]);
    }

    public static Data[] relabelWithFileNameHierarchy(Data[] data, File file) {
        File absoluteFile = file.getAbsoluteFile();
        File parent = absoluteFile.getParentFile();
        String parentName = parent.getName();
        String prefix = parentName.trim().length() == 0 ? File.separator : "..." + File.separator + parentName + File.separator;
        ArrayList<Data> possibleParents = new ArrayList<Data>(data.length);
        Data[] dataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Data datum = dataArray[n2];
            Dictionary labeledDatumMetadata = datum.getMetadata();
            Object labelObject = labeledDatumMetadata.get("Label");
            if (labelObject == null || "".equals(labelObject.toString())) {
                Data dataParent = PrettyLabeler.getParent(labeledDatumMetadata);
                if (!possibleParents.contains(dataParent)) {
                    labeledDatumMetadata.put("Label", String.valueOf(prefix) + absoluteFile.getName());
                }
                possibleParents.add(datum);
            }
            ++n2;
        }
        return data;
    }

    private static Data getParent(Dictionary<String, Object> labeledDatumMetadata) {
        return (Data)labeledDatumMetadata.get("Parent");
    }
}

