/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.fileloader;

import java.io.File;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.reference.app.service.fileloader.FileFormatSelector;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class ValidatorSelectorRunnable
implements Runnable {
    private IWorkbenchWindow window;
    private BundleContext bundleContext;
    private File file;
    private AlgorithmFactory chosenValidator;

    public ValidatorSelectorRunnable(IWorkbenchWindow window, BundleContext bundleContext, File file) {
        this.window = window;
        this.bundleContext = bundleContext;
        this.file = file;
    }

    public AlgorithmFactory getValidator() {
        return this.chosenValidator;
    }

    @Override
    public void run() {
        String fileExtension = ValidatorSelectorRunnable.getFileExtension(this.file.getAbsolutePath()).toLowerCase().substring(1);
        ServiceReference[] supportingValidators = ValidatorSelectorRunnable.getSupportingValidators(this.bundleContext, fileExtension);
        if (supportingValidators.length == 0) {
            ServiceReference[] allValidators = ValidatorSelectorRunnable.getAllValidators(this.bundleContext);
            FileFormatSelector validatorSelector = new FileFormatSelector("Load", this.window.getShell(), this.bundleContext, allValidators, this.file);
            validatorSelector.open();
            this.chosenValidator = validatorSelector.getValidator();
        } else if (supportingValidators.length == 1) {
            ServiceReference onlyPossibleValidator = supportingValidators[0];
            this.chosenValidator = (AlgorithmFactory)this.bundleContext.getService(onlyPossibleValidator);
        }
        if (supportingValidators.length > 1) {
            FileFormatSelector validatorSelector = new FileFormatSelector("Load", this.window.getShell(), this.bundleContext, supportingValidators, this.file);
            validatorSelector.open();
            this.chosenValidator = validatorSelector.getValidator();
        }
    }

    public static ServiceReference[] getAllValidators(BundleContext bundleContext) {
        try {
            String validatorsQuery = "(&(type=validator)(in_data=file-ext:*))";
            ServiceReference[] allValidators = bundleContext.getAllServiceReferences(AlgorithmFactory.class.getName(), validatorsQuery);
            if (allValidators == null) {
                return new ServiceReference[0];
            }
            return allValidators;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return new ServiceReference[0];
        }
    }

    public static ServiceReference[] getSupportingValidators(BundleContext bundleContext, String fileExtension) {
        try {
            String validatorsQuery = "(& (type=validator)(|(in_data=file-ext:" + fileExtension + ")" + "(also_validates=" + fileExtension + ")" + "))";
            ServiceReference[] supportingValidators = bundleContext.getAllServiceReferences(AlgorithmFactory.class.getName(), validatorsQuery);
            if (supportingValidators == null) {
                return new ServiceReference[0];
            }
            return supportingValidators;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return new ServiceReference[0];
        }
    }

    private static String getFileExtension(String filePath) {
        int periodPosition = filePath.lastIndexOf(".");
        if (periodPosition != -1 && periodPosition + 1 < filePath.length()) {
            return filePath.substring(periodPosition);
        }
        return "";
    }
}

