/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.filesaver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.cishell.app.service.filesaver.AbstractFileSaverService;
import org.cishell.app.service.filesaver.FileSaveException;
import org.cishell.framework.data.Data;
import org.cishell.reference.app.service.filesaver.DataFormatChooser;
import org.cishell.reference.app.service.filesaver.SaveAsController;
import org.cishell.service.conversion.Converter;
import org.cishell.service.conversion.DataConversionService;
import org.cishell.service.guibuilder.GUIBuilderService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.ComponentContext;

public class FileSaverServiceImpl
extends AbstractFileSaverService {
    public static final String SAVE_DIALOG_TITLE = "Save";
    private DataConversionService conversionManager;
    private GUIBuilderService guiBuilder;

    protected void activate(ComponentContext componentContext) {
        this.conversionManager = (DataConversionService)componentContext.locateService("DCS");
        this.guiBuilder = (GUIBuilderService)componentContext.locateService("GBS");
    }

    public Converter promptForConverter(Data outDatum, String targetMimeType) throws FileSaveException {
        Converter[] converters = this.conversionManager.findConverters(outDatum, targetMimeType);
        if (converters.length == 0) {
            throw new FileSaveException("No appropriate converters.");
        }
        if (converters.length == 1) {
            Converter onlyConverter = converters[0];
            return onlyConverter;
        }
        Shell parentShell = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
        if (parentShell.isDisposed()) {
            throw new FileSaveException("Can't create dialog window -- graphical environment not available.");
        }
        return this.showDataFormatChooser(outDatum, converters, parentShell);
    }

    private Converter showDataFormatChooser(final Data outDatum, final Converter[] converters, final Shell parentShell) throws FileSaveException {
        try {
            final Converter[] chosenConverter = new Converter[1];
            this.guiRun(new Runnable(){

                @Override
                public void run() {
                    DataFormatChooser formatChooser = new DataFormatChooser(outDatum, parentShell, converters, FileSaverServiceImpl.SAVE_DIALOG_TITLE);
                    formatChooser.createContent((Composite)new Shell(parentShell));
                    formatChooser.open();
                    chosenConverter[0] = formatChooser.getChosenConverter();
                }
            });
            return chosenConverter[0];
        }
        catch (Exception e) {
            throw new FileSaveException(e.getMessage(), (Throwable)e);
        }
    }

    public File promptForTargetFile(final String suggestedFileName, final String defaultFileExtension) throws FileSaveException {
        final File[] resultFile = new File[1];
        try {
            this.guiRun(new Runnable(){

                @Override
                public void run() {
                    SaveAsController saveAs = new SaveAsController(FileSaverServiceImpl.this.guiBuilder);
                    resultFile[0] = saveAs.open(suggestedFileName, defaultFileExtension);
                }
            });
            return resultFile[0];
        }
        catch (Throwable e) {
            throw new FileSaveException(e.getMessage(), e);
        }
    }

    public void saveTo(File sourceFile, File targetFile) throws FileSaveException {
        if (sourceFile != null && targetFile != null && sourceFile.exists()) {
            FileSaverServiceImpl.copyFile(sourceFile, targetFile);
        }
    }

    private void guiRun(Runnable run) {
        Shell parentShell = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            run.run();
        } else {
            parentShell.getDisplay().syncExec(run);
        }
    }

    private static void copyFile(File sourceFile, File targetFile) throws FileSaveException {
        try {
            FileInputStream inputStream = new FileInputStream(sourceFile);
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            FileChannel readableChannel = inputStream.getChannel();
            FileChannel writableChannel = outputStream.getChannel();
            writableChannel.truncate(0L);
            writableChannel.transferFrom(readableChannel, 0L, readableChannel.size());
            inputStream.close();
            outputStream.close();
        }
        catch (IOException ioException) {
            String exceptionMessage = "An error occurred when copying from the file \"" + sourceFile.getAbsolutePath() + "\" to the file \"" + targetFile.getAbsolutePath() + "\".";
            throw new FileSaveException(exceptionMessage, (Throwable)ioException);
        }
    }
}

