/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.persistence;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractDialog
extends Dialog {
    private static final int DETAILS_HEIGHT = 75;
    public static Image INFORMATION;
    public static Image WARNING;
    public static Image ERROR;
    public static Image QUESTION;
    public static Image WORKING;
    private String description = "";
    private String detailsString = "";
    private Text detailsText;
    private Shell shell;
    private Image image;
    private boolean success;
    private Composite header;
    private Composite content;
    private Composite buttons;
    private Shell parent;

    static {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                INFORMATION = Display.getDefault().getSystemImage(2);
                WARNING = Display.getDefault().getSystemImage(8);
                ERROR = Display.getDefault().getSystemImage(1);
                QUESTION = Display.getDefault().getSystemImage(4);
                WORKING = Display.getDefault().getSystemImage(16);
            }
        };
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            runner.run();
        } else {
            Display.getDefault().asyncExec(runner);
        }
    }

    public AbstractDialog(Shell parent, String title, Image image) {
        super(parent, 0);
        this.setText(title);
        this.image = image;
        this.parent = parent;
        this.init();
    }

    public void close(boolean success) {
        this.shell.dispose();
        this.success = success;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void init() {
        if (this.shell != null) {
            this.shell.dispose();
        }
        this.shell = new Shell(this.parent, 67696);
        if (this.parent != null) {
            this.shell.setImage(this.parent.getImage());
        }
        this.shell.setText(this.getText());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setLayout((Layout)layout);
    }

    public boolean open() {
        if (this.shell.getDisplay().getThread() == Thread.currentThread()) {
            this.doOpen();
        } else {
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractDialog.this.doOpen();
                }
            });
        }
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.success;
    }

    protected void doOpen() {
        this.success = true;
        this.setupHeader();
        this.setupContent();
        this.setupButtons();
        this.shell.pack();
        this.setLocation();
        this.shell.open();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AbstractDialog.this.success = false;
            }
        });
    }

    private void setLocation() {
        Point parentLocation = this.parent.getLocation();
        int parentWidth = this.parent.getSize().x;
        int parentHeight = this.parent.getSize().y;
        int shellWidth = this.shell.getSize().x;
        int shellHeight = this.shell.getSize().y;
        int x = parentLocation.x + (parentWidth - shellWidth) / 2;
        int y = parentLocation.y + (parentHeight - shellHeight) / 2;
        this.shell.setLocation(x, y);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDetails(String details) {
        this.detailsString = details;
    }

    public abstract void createDialogButtons(Composite var1);

    public abstract Composite createContent(Composite var1);

    private void setupHeader() {
        this.header = new Composite((Composite)this.shell, 0);
        this.header.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.header.setLayout((Layout)layout);
        Label canvas = new Label(this.header, 0);
        if (this.image != null) {
            canvas.setImage(this.image);
        }
        GridData canvasData = new GridData();
        canvasData.heightHint = this.image.getBounds().height;
        canvas.setLayoutData((Object)canvasData);
        Label desc = new Label(this.header, 64);
        if (this.description != null && !this.description.equals("")) {
            desc.setText(this.description);
        }
    }

    private void setupContent() {
        this.content = this.createContent((Composite)this.shell);
        if (this.content != null) {
            this.content.setLayoutData((Object)new GridData(1808));
        }
    }

    private void setupButtons() {
        this.buttons = new Composite((Composite)this.shell, 0);
        this.buttons.setLayoutData((Object)new GridData(896));
        this.createDialogButtons(this.buttons);
        Control[] controls = this.buttons.getChildren();
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.numColumns = controls.length + 1;
        buttonsLayout.makeColumnsEqualWidth = true;
        this.buttons.setLayout((Layout)buttonsLayout);
        int i = 0;
        while (i < controls.length) {
            controls[i].setLayoutData((Object)new GridData(768));
            ++i;
        }
        final Button details = new Button(this.buttons, 8);
        details.setText("Details >>");
        details.setLayoutData((Object)new GridData(768));
        details.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public synchronized void widgetSelected(SelectionEvent e) {
                GridData data = (GridData)AbstractDialog.this.detailsText.getLayoutData();
                if (AbstractDialog.this.detailsText.getVisible()) {
                    AbstractDialog.this.detailsText.setText("");
                    details.setText("Details >>");
                    data.heightHint = 0;
                    data.grabExcessHorizontalSpace = false;
                    data.grabExcessVerticalSpace = false;
                } else {
                    AbstractDialog.this.detailsText.setText(AbstractDialog.this.detailsString);
                    details.setText("Details <<");
                    data.heightHint = 75;
                    data.grabExcessHorizontalSpace = true;
                    data.grabExcessVerticalSpace = true;
                }
                AbstractDialog.this.detailsText.setLayoutData((Object)data);
                AbstractDialog.this.detailsText.setVisible(!AbstractDialog.this.detailsText.getVisible());
                AbstractDialog.this.shell.setSize(AbstractDialog.this.shell.computeSize(-1, -1));
                AbstractDialog.this.shell.layout();
            }
        });
        this.setupDetails();
        details.setEnabled(this.detailsString != null && !this.detailsString.equals(""));
    }

    private void setupDetails() {
        this.detailsText = new Text((Composite)this.shell, 2624);
        this.detailsText.setEditable(false);
        this.detailsText.setBackground(Display.getCurrent().getSystemColor(1));
        GridData data = new GridData(1808);
        data.widthHint = 400;
        this.detailsText.setLayoutData((Object)data);
        this.detailsText.setVisible(false);
    }

    public static boolean openError(Shell parent, String title, String message, String details) {
        return AbstractDialog.openOKDialog(parent, ERROR, title, message, details);
    }

    public static boolean openInformation(Shell parent, String title, String message, String details) {
        return AbstractDialog.openOKDialog(parent, INFORMATION, title, message, details);
    }

    public static boolean openWarning(Shell parent, String title, String message, String details) {
        return AbstractDialog.openOKDialog(parent, WARNING, title, message, details);
    }

    public static boolean openQuestion(Shell parent, String title, String message, String details) {
        return AbstractDialog.openConfirmDenyDialog(parent, QUESTION, title, message, details, "Yes", "No");
    }

    public static boolean openConfirm(Shell parent, String title, String message, String details) {
        return AbstractDialog.openConfirmDenyDialog(parent, QUESTION, title, message, details, "OK", "Cancel");
    }

    private static boolean openOKDialog(Shell parent, Image image, String title, String message, String details) {
        AbstractDialog okDialog = new AbstractDialog(parent, title, image){

            @Override
            public void createDialogButtons(Composite parent) {
                Button ok = new Button(parent, 8);
                ok.setText("OK");
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.close(true);
                    }
                });
            }

            @Override
            public Composite createContent(Composite parent) {
                return null;
            }
        };
        okDialog.setDescription(message);
        okDialog.setDetails(details);
        return okDialog.open();
    }

    private static boolean openConfirmDenyDialog(Shell parent, Image image, String title, String message, String details, final String confirmLabel, final String denyLabel) {
        AbstractDialog dialog = new AbstractDialog(parent, title, image){

            @Override
            public void createDialogButtons(Composite parent) {
                Button confirm = new Button(parent, 8);
                if (confirmLabel != null) {
                    confirm.setText(confirmLabel);
                }
                confirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.close(true);
                    }
                });
                Button deny = new Button(parent, 8);
                if (denyLabel != null) {
                    deny.setText(denyLabel);
                }
                deny.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.close(false);
                    }
                });
            }

            @Override
            public Composite createContent(Composite parent) {
                return null;
            }
        };
        dialog.setDescription(message);
        dialog.setDetails(details);
        return dialog.open();
    }
}

