/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.scheduler;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import org.cishell.app.service.scheduler.SchedulerListener;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;
import org.cishell.reference.app.service.scheduler.AlgorithmTask;
import org.osgi.framework.ServiceReference;

class AlgorithmSchedulerTask
extends TimerTask
implements SchedulerListener {
    public static final int AS_MANY_SIMULTANEOUS_ALGORITHMS_AS_NEEDED = -1;
    private Map<Algorithm, AlgorithmTask> tasksByAlgorithms = Collections.synchronizedMap(new HashMap());
    private Map<Algorithm, ServiceReference> serviceReferencesByAlgorithms = new HashMap<Algorithm, ServiceReference>();
    private volatile boolean isRunning = true;
    private volatile int runningTaskCount = 0;
    private SchedulerListener schedulerListener;
    private int maxSimultaneousAlgorithms = -1;

    public final synchronized void setMaxSimultaneousAlgorithms(int max) {
        this.maxSimultaneousAlgorithms = max < -1 ? -1 : max;
    }

    public synchronized Algorithm[] getScheduledAlgorithms() {
        return this.tasksByAlgorithms.keySet().toArray(new Algorithm[0]);
    }

    public final synchronized boolean isEmpty() {
        return this.tasksByAlgorithms.size() == 0;
    }

    public final synchronized int numRunning() {
        return this.runningTaskCount;
    }

    public AlgorithmSchedulerTask(SchedulerListener listener) {
        this.setSchedulerListener(listener);
    }

    public final synchronized void setSchedulerListener(SchedulerListener listener) {
        this.schedulerListener = listener;
    }

    public final ServiceReference getServiceReference(Algorithm algorithm) {
        return this.serviceReferencesByAlgorithms.get(algorithm);
    }

    public final synchronized Calendar getScheduledTime(Algorithm algorithm) {
        AlgorithmTask task = this.tasksByAlgorithms.get(algorithm);
        if (task != null) {
            return task.getScheduledTime();
        }
        return null;
    }

    public final synchronized boolean cancel(Algorithm algorithm) {
        AlgorithmTask task = this.tasksByAlgorithms.get(algorithm);
        if (task == null) {
            return false;
        }
        return task.cancel();
    }

    public final synchronized void schedule(Algorithm alg, ServiceReference ref, Calendar time) {
        AlgorithmTask task = this.tasksByAlgorithms.get(alg);
        if (task != null) {
            AlgorithmTask.AlgorithmState state = task.getState();
            if (state.equals(AlgorithmTask.AlgorithmState.RUNNING)) {
                throw new RuntimeException("Cannot schedule running algorithm. Check state of algorithm first.");
            }
            if (state.equals(AlgorithmTask.AlgorithmState.NEW)) {
                throw new RuntimeException("Algorithm is already scheduled to run. Cancel existing schedule first.");
            }
            if (state.equals(AlgorithmTask.AlgorithmState.STOPPED)) {
                this.purgeFinished();
            } else {
                throw new IllegalStateException("State was not one of allowable states: " + state);
            }
        }
        new AlgorithmTask(alg, ref, time, this);
    }

    public final synchronized int getMaxSimultaneousAlgs() {
        return this.maxSimultaneousAlgorithms;
    }

    public final synchronized void registerAlgorithmTask(Algorithm algorithm, AlgorithmTask algorithmTask) {
        this.serviceReferencesByAlgorithms.put(algorithm, algorithmTask.getServiceReference());
        this.tasksByAlgorithms.put(algorithm, algorithmTask);
    }

    public final synchronized AlgorithmTask.AlgorithmState getAlgorithmState(Algorithm algorithm) {
        AlgorithmTask task = this.tasksByAlgorithms.get(algorithm);
        if (task == null) {
            throw new NoSuchElementException("Algorithm doesn't exist.");
        }
        return task.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void purgeFinished() {
        AlgorithmSchedulerTask algorithmSchedulerTask = this;
        synchronized (algorithmSchedulerTask) {
            Iterator<Map.Entry<Algorithm, AlgorithmTask>> entries = this.tasksByAlgorithms.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Algorithm, AlgorithmTask> entry = entries.next();
                AlgorithmTask task = entry.getValue();
                if (task.getState() != AlgorithmTask.AlgorithmState.STOPPED) continue;
                entries.remove();
                this.serviceReferencesByAlgorithms.remove(entry.getKey());
            }
        }
    }

    private final synchronized boolean limitReached() {
        return this.maxSimultaneousAlgorithms != -1 && this.runningTaskCount >= this.maxSimultaneousAlgorithms;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isRunning) {
            AlgorithmSchedulerTask algorithmSchedulerTask = this;
            synchronized (algorithmSchedulerTask) {
                Date now = Calendar.getInstance().getTime();
                Collection<AlgorithmTask> tasks = this.tasksByAlgorithms.values();
                for (AlgorithmTask task : tasks) {
                    if (this.limitReached()) {
                        return;
                    }
                    if (task.getState() != AlgorithmTask.AlgorithmState.NEW || now.compareTo(task.getScheduledTime().getTime()) < 0) continue;
                    task.start();
                }
            }
        }
    }

    public synchronized void algorithmScheduled(Algorithm algorithm, Calendar time) {
        this.schedulerListener.algorithmScheduled(algorithm, time);
    }

    public synchronized void algorithmStarted(Algorithm algorithm) {
        ++this.runningTaskCount;
        this.schedulerListener.algorithmStarted(algorithm);
    }

    public synchronized void algorithmError(Algorithm algorithm, Throwable error) {
        --this.runningTaskCount;
        this.schedulerListener.algorithmError(algorithm, error);
        this.purgeFinished();
    }

    public synchronized void algorithmFinished(Algorithm algorithm, Data[] createdDM) {
        --this.runningTaskCount;
        this.schedulerListener.algorithmFinished(algorithm, createdDM);
        this.purgeFinished();
    }

    public synchronized void algorithmRescheduled(Algorithm algorithm, Calendar time) {
        this.schedulerListener.algorithmRescheduled(algorithm, time);
    }

    public synchronized void algorithmUnscheduled(Algorithm algorithm) {
        this.schedulerListener.algorithmUnscheduled(algorithm);
    }

    public synchronized void schedulerCleared() {
        this.schedulerListener.schedulerCleared();
    }

    public synchronized void schedulerRunStateChanged(boolean isRunning) {
        this.schedulerListener.schedulerRunStateChanged(isRunning);
    }
}

