/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.scheduler;

import com.google.common.base.Objects;
import java.util.Calendar;
import org.cishell.app.service.scheduler.SchedulerListener;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;
import org.cishell.reference.app.service.scheduler.AlgorithmSchedulerTask;
import org.osgi.framework.ServiceReference;

class AlgorithmTask
implements Runnable {
    private volatile boolean isCanceled = false;
    private final Algorithm algorithm;
    private final Calendar scheduledTime;
    private final ServiceReference serviceReference;
    private volatile AlgorithmState state;
    private Data[] result;
    private Exception exceptionThrown;
    private SchedulerListener schedulerListener;

    public final synchronized boolean cancel() {
        if (this.isCanceled) {
            return true;
        }
        if (this.state.equals(AlgorithmState.RUNNING)) {
            return false;
        }
        this.state = AlgorithmState.STOPPED;
        this.isCanceled = true;
        return this.isCanceled;
    }

    public final synchronized void start() {
        if (this.isCanceled) {
            return;
        }
        this.setState(AlgorithmState.RUNNING);
        new Thread(this).start();
    }

    public AlgorithmTask(Algorithm algorithm, ServiceReference serviceReference, Calendar scheduledTime, AlgorithmSchedulerTask algorithmSchedulerTask) {
        this.algorithm = algorithm;
        this.serviceReference = serviceReference;
        this.scheduledTime = scheduledTime;
        this.schedulerListener = algorithmSchedulerTask;
        algorithmSchedulerTask.registerAlgorithmTask(algorithm, this);
        this.init();
    }

    public final synchronized Calendar getScheduledTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.scheduledTime.getTime());
        return calendar;
    }

    public final synchronized ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    private final void init() {
        this.result = null;
        this.setState(AlgorithmState.NEW);
    }

    public final synchronized Data[] getResult() {
        return this.result;
    }

    private final synchronized void setState(AlgorithmState state) {
        this.state = state;
        if (this.schedulerListener != null) {
            this.state.performAction(this.algorithm, this.schedulerListener, this.scheduledTime, this.getResult(), this.exceptionThrown);
            this.isCanceled = this.state.isCanceledNow();
        }
    }

    public final synchronized AlgorithmState getState() {
        return this.state;
    }

    @Override
    public void run() {
        try {
            try {
                this.result = this.algorithm.execute();
            }
            catch (Exception e) {
                this.exceptionThrown = e;
                this.setState(AlgorithmState.ERROR);
                this.setState(AlgorithmState.STOPPED);
            }
        }
        finally {
            this.setState(AlgorithmState.STOPPED);
        }
    }

    static class AlgorithmState {
        public static final AlgorithmState NEW = new AlgorithmState("NEW", false){

            @Override
            public void performAction(Algorithm algorithm, SchedulerListener schedulerListener, Calendar scheduledTime, Data[] result, Exception exceptionThrown) {
                schedulerListener.algorithmScheduled(algorithm, scheduledTime);
            }
        };
        public static final AlgorithmState RUNNING = new AlgorithmState("RUNNING", false){

            @Override
            public void performAction(Algorithm algorithm, SchedulerListener schedulerListener, Calendar scheduledTime, Data[] result, Exception exceptionThrown) {
                schedulerListener.algorithmStarted(algorithm);
            }
        };
        public static final AlgorithmState STOPPED = new AlgorithmState("STOPPED", true){

            @Override
            public void performAction(Algorithm algorithm, SchedulerListener schedulerListener, Calendar scheduledTime, Data[] result, Exception exceptionThrown) {
                schedulerListener.algorithmFinished(algorithm, result);
            }
        };
        public static final AlgorithmState ERROR = new AlgorithmState("ERROR", true){

            @Override
            public void performAction(Algorithm algorithm, SchedulerListener schedulerListener, Calendar scheduledTime, Data[] result, Exception exceptionThrown) {
                schedulerListener.algorithmError(algorithm, (Throwable)exceptionThrown);
            }
        };
        private String name;
        private boolean isCanceled;

        public AlgorithmState(String name, boolean isCanceled) {
            this.name = name;
            this.isCanceled = isCanceled;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AlgorithmState)) {
                return false;
            }
            AlgorithmState other = (AlgorithmState)obj;
            return Objects.equal((Object)this.name, (Object)other.name);
        }

        public void performAction(Algorithm algorithm, SchedulerListener schedulerListener, Calendar scheduledTime, Data[] result, Exception exceptionThrown) {
            throw new IllegalStateException("Encountered illegal algorithm state: " + this);
        }

        public boolean isCanceledNow() {
            return this.isCanceled;
        }
    }
}

