/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.scheduler;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.cishell.app.service.scheduler.SchedulerListener;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;

class SchedulerListenerInformer
implements SchedulerListener {
    private List<SchedulerListener> schedulerListeners = new ArrayList<SchedulerListener>();

    public void addSchedulerListener(SchedulerListener listener) {
        this.schedulerListeners.add(listener);
    }

    public void removeSchedulerListener(SchedulerListener listener) {
        this.schedulerListeners.remove(listener);
    }

    public void algorithmScheduled(Algorithm algorithm, Calendar time) {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.algorithmScheduled(algorithm, time);
        }
    }

    public synchronized void algorithmStarted(Algorithm algorithm) {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.algorithmStarted(algorithm);
        }
    }

    public void algorithmError(Algorithm algorithm, Throwable error) {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.algorithmError(algorithm, error);
        }
    }

    public void algorithmFinished(Algorithm algorithm, Data[] createdDM) {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.algorithmFinished(algorithm, createdDM);
        }
    }

    public void algorithmRescheduled(Algorithm algorithm, Calendar time) {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.algorithmRescheduled(algorithm, time);
        }
    }

    public void algorithmUnscheduled(Algorithm algorithm) {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.algorithmUnscheduled(algorithm);
        }
    }

    public void schedulerCleared() {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.schedulerCleared();
        }
    }

    public void schedulerRunStateChanged(boolean isRunning) {
        for (SchedulerListener schedulerListener : this.schedulerListeners) {
            schedulerListener.schedulerRunStateChanged(isRunning);
        }
    }
}

