/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.app.service.scheduler;

import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.cishell.app.service.scheduler.SchedulerListener;
import org.cishell.app.service.scheduler.SchedulerService;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.reference.app.service.scheduler.AlgorithmSchedulerTask;
import org.cishell.reference.app.service.scheduler.AlgorithmTask;
import org.cishell.reference.app.service.scheduler.SchedulerListenerInformer;
import org.osgi.framework.ServiceReference;

public class SchedulerServiceImpl
implements SchedulerService {
    private Timer schedulerTimer;
    private AlgorithmSchedulerTask algorithmSchedulerTask;
    private SchedulerListenerInformer schedulerListenerInformer;
    private boolean isShutDown = true;

    public SchedulerServiceImpl() {
        this.initialize();
    }

    public SchedulerServiceImpl(int maxSimultaneousAlgorithm) {
        this();
        this.algorithmSchedulerTask.setMaxSimultaneousAlgorithms(maxSimultaneousAlgorithm);
        this.isShutDown = false;
    }

    public final synchronized void setMaxSimultaneousAlgorithms(int max) {
        this.algorithmSchedulerTask.setMaxSimultaneousAlgorithms(max);
    }

    private final void initialize() {
        this.schedulerTimer = new Timer(true);
        this.schedulerListenerInformer = new SchedulerListenerInformer();
        this.algorithmSchedulerTask = new AlgorithmSchedulerTask(this.schedulerListenerInformer);
        this.schedulerTimer.schedule((TimerTask)this.algorithmSchedulerTask, 0L, 500L);
    }

    public final synchronized void shutDown() {
        this.algorithmSchedulerTask.cancel();
        this.schedulerTimer.cancel();
        this.isShutDown = true;
    }

    public final boolean isEmpty() {
        return this.algorithmSchedulerTask.isEmpty();
    }

    public final boolean isRunning() {
        return this.algorithmSchedulerTask.isRunning();
    }

    public final int numRunning() {
        return this.algorithmSchedulerTask.numRunning();
    }

    public final boolean isShutDown() {
        return this.isShutDown;
    }

    public boolean reschedule(Algorithm algorithm, Calendar newTime) {
        boolean canReschedule;
        block5: {
            ServiceReference reference = this.algorithmSchedulerTask.getServiceReference(algorithm);
            canReschedule = false;
            try {
                AlgorithmTask.AlgorithmState algorithmState = this.algorithmSchedulerTask.getAlgorithmState(algorithm);
                if (algorithmState.equals(AlgorithmTask.AlgorithmState.RUNNING)) {
                    canReschedule = false;
                    break block5;
                }
                if (algorithmState.equals(AlgorithmTask.AlgorithmState.STOPPED)) {
                    this.algorithmSchedulerTask.purgeFinished();
                    this.algorithmSchedulerTask.schedule(algorithm, reference, newTime);
                    canReschedule = true;
                    break block5;
                }
                if (algorithmState.equals(AlgorithmTask.AlgorithmState.NEW)) {
                    this.algorithmSchedulerTask.cancel(algorithm);
                    this.algorithmSchedulerTask.schedule(algorithm, reference, newTime);
                    break block5;
                }
                throw new IllegalStateException("Encountered an invalid state: " + algorithmState);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.algorithmSchedulerTask.schedule(algorithm, reference, newTime);
                canReschedule = true;
            }
        }
        return canReschedule;
    }

    public void runNow(Algorithm algorithm, ServiceReference reference) {
        this.schedule(algorithm, reference);
    }

    public void schedule(Algorithm algorithm, ServiceReference reference) {
        this.schedule(algorithm, reference, Calendar.getInstance());
    }

    public void schedule(Algorithm algorithm, ServiceReference reference, Calendar time) {
        this.algorithmSchedulerTask.schedule(algorithm, reference, time);
    }

    public boolean unschedule(Algorithm algorithm) {
        return this.algorithmSchedulerTask.cancel(algorithm);
    }

    public void addSchedulerListener(SchedulerListener listener) {
        this.schedulerListenerInformer.addSchedulerListener(listener);
    }

    public void removeSchedulerListener(SchedulerListener listener) {
        this.schedulerListenerInformer.removeSchedulerListener(listener);
    }

    public synchronized void clearSchedule() {
        this.algorithmSchedulerTask.cancel();
        this.schedulerTimer.cancel();
        this.schedulerTimer = new Timer(true);
        this.algorithmSchedulerTask = new AlgorithmSchedulerTask(this.schedulerListenerInformer);
        this.schedulerTimer.schedule((TimerTask)this.algorithmSchedulerTask, 0L, 500L);
        this.schedulerListenerInformer.schedulerCleared();
    }

    public Algorithm[] getScheduledAlgorithms() {
        return this.algorithmSchedulerTask.getScheduledAlgorithms();
    }

    public Calendar getScheduledTime(Algorithm algorithm) {
        return this.algorithmSchedulerTask.getScheduledTime(algorithm);
    }

    public ServiceReference getServiceReference(Algorithm algorithm) {
        return this.algorithmSchedulerTask.getServiceReference(algorithm);
    }

    public void setRunning(boolean isRunning) {
        this.algorithmSchedulerTask.setRunning(isRunning);
        this.schedulerListenerInformer.schedulerRunStateChanged(isRunning);
    }
}

