/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.service.conversion;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.AlgorithmProperty;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;
import org.cishell.utility.dict.ImmutableDictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeProvider;

public class ConverterImpl
implements Converter,
AlgorithmFactory,
AlgorithmProperty {
    private final ImmutableList<ServiceReference<AlgorithmFactory>> serviceReferences;
    private final BundleContext bContext;
    private final ImmutableDictionary<String, Object> properties;
    private final CIShellContext ciContext;

    private ConverterImpl(BundleContext bContext, CIShellContext ciContext, List<ServiceReference<AlgorithmFactory>> refs, Dictionary<String, Object> properties) {
        this.bContext = bContext;
        this.ciContext = ciContext;
        this.serviceReferences = ImmutableList.copyOf(refs);
        this.properties = ImmutableDictionary.fromDictionary(properties);
    }

    static ConverterImpl createNoOpConverter(BundleContext bContext, CIShellContext ciContext, String dataFormat) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("in_data", dataFormat);
        ((Dictionary)properties).put("out_data", dataFormat);
        ((Dictionary)properties).put("label", ((Dictionary)properties).get("in_data") + " --(no-op)-> " + ((Dictionary)properties).get("out_data"));
        ((Dictionary)properties).put("conversion", "lossless");
        ConverterImpl toReturn = new ConverterImpl(bContext, ciContext, (List<ServiceReference<AlgorithmFactory>>)ImmutableList.of(), properties);
        return toReturn;
    }

    static ConverterImpl createConverter(BundleContext bContext, CIShellContext ciContext, List<ServiceReference<AlgorithmFactory>> refs) {
        if (refs.size() == 0) {
            throw new IllegalArgumentException("This static factory requires 1 or more algorithms in the chain; try .createNoOpConverter");
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("in_data", refs.get(0).getProperty("in_data"));
        ((Dictionary)properties).put("out_data", refs.get(refs.size() - 1).getProperty("out_data"));
        ((Dictionary)properties).put("label", ((Dictionary)properties).get("in_data") + " -> " + ((Dictionary)properties).get("out_data"));
        String lossiness = ConverterImpl.calculateLossiness(refs);
        ((Dictionary)properties).put("conversion", lossiness);
        return new ConverterImpl(bContext, ciContext, refs, properties);
    }

    public Data convert(Data inData) throws ConversionException {
        Data[] resultDataArray;
        AlgorithmFactory factory = this.getAlgorithmFactory();
        Algorithm algorithm = factory.createAlgorithm(new Data[]{inData}, new Hashtable(), this.ciContext);
        try {
            resultDataArray = algorithm.execute();
        }
        catch (AlgorithmExecutionException e) {
            e.printStackTrace();
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConversionException("Unexpected error: " + e.getMessage(), (Throwable)e);
        }
        Object result = null;
        if (resultDataArray != null && resultDataArray.length > 0) {
            result = resultDataArray[0].getData();
        }
        if (result != null) {
            Dictionary properties = inData.getMetadata();
            Hashtable newProperties = new Hashtable();
            Enumeration propertyKeys = properties.keys();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                ((Dictionary)newProperties).put(key, properties.get(key));
            }
            String outFormat = (String)this.getProperties().get("out_data");
            return new BasicData(newProperties, result, outFormat);
        }
        return null;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return this;
    }

    public ServiceReference[] getConverterChain() {
        return (ServiceReference[])this.serviceReferences.toArray((Object[])new ServiceReference[0]);
    }

    public ImmutableList<ServiceReference<AlgorithmFactory>> getConverterList() {
        return this.serviceReferences;
    }

    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    public Algorithm createAlgorithm(Data[] dm, Dictionary parameters, CIShellContext context) {
        return new ConverterAlgorithm(dm, parameters, context, this.serviceReferences);
    }

    public MetaTypeProvider createParameters(Data[] dm) {
        return null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.properties, this.serviceReferences});
    }

    public String toString() {
        return Objects.toStringHelper(Converter.class).add("properties", this.properties).add("chain", this.serviceReferences).toString();
    }

    public boolean equals(Object compareTo) {
        if (!(compareTo instanceof ConverterImpl)) {
            return false;
        }
        ConverterImpl that = (ConverterImpl)compareTo;
        return this.properties.equals(that.properties) && this.serviceReferences.equals(that.serviceReferences);
    }

    public String calculateLossiness() {
        return ConverterImpl.calculateLossiness(this.getConverterList());
    }

    private static String calculateLossiness(List<ServiceReference<AlgorithmFactory>> serviceReferences) {
        for (ServiceReference<AlgorithmFactory> serviceReference : serviceReferences) {
            if (!"lossy".equals(serviceReference.getProperty("conversion"))) continue;
            return "lossy";
        }
        return "lossless";
    }

    private class ConverterAlgorithm
    implements Algorithm {
        public static final String FILE_EXTENSION_PREFIX = "file-ext:";
        public static final String MIME_TYPE_PREFIX = "file:";
        private Data[] inData;
        private Dictionary<String, Object> parameters;
        private CIShellContext ciShellContext;
        private LogService logger;
        private ImmutableList<ServiceReference<AlgorithmFactory>> serviceReferences;

        public ConverterAlgorithm(Data[] inData, Dictionary<String, Object> parameters, CIShellContext ciShellContext, ImmutableList<ServiceReference<AlgorithmFactory>> serviceReferences) {
            this.inData = inData;
            this.parameters = parameters;
            this.ciShellContext = ciShellContext;
            this.serviceReferences = serviceReferences;
            this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
        }

        public Data[] execute() throws AlgorithmExecutionException {
            Data[] convertedData = this.inData;
            int ii = 0;
            while (ii < this.serviceReferences.size()) {
                AlgorithmFactory factory = (AlgorithmFactory)ConverterImpl.this.bContext.getService((ServiceReference)this.serviceReferences.get(ii));
                if (factory != null) {
                    Algorithm algorithm = factory.createAlgorithm(convertedData, this.parameters, this.ciShellContext);
                    try {
                        convertedData = algorithm.execute();
                    }
                    catch (AlgorithmExecutionException e) {
                        boolean isLastStep;
                        boolean bl = isLastStep = ii == this.serviceReferences.size() - 1;
                        if (isLastStep && this.isHandler((ServiceReference<AlgorithmFactory>)((ServiceReference)this.serviceReferences.get(ii)))) {
                            String warningMessage = "Warning: Attempting to convert data without validating the output since the validator failed with this problem:\n    " + this.createErrorMessage((ServiceReference<AlgorithmFactory>)((ServiceReference)this.serviceReferences.get(ii)), e);
                            this.logger.log(2, warningMessage, (Throwable)e);
                            return convertedData;
                        }
                        throw new AlgorithmExecutionException(this.createErrorMessage((ServiceReference<AlgorithmFactory>)((ServiceReference)this.serviceReferences.get(ii)), e), (Throwable)e);
                    }
                } else {
                    throw new AlgorithmExecutionException("Missing subconverter: " + ((ServiceReference)this.serviceReferences.get(ii)).getProperty("service.pid"));
                }
                ++ii;
            }
            return convertedData;
        }

        private boolean isHandler(ServiceReference<AlgorithmFactory> ref) {
            String algorithmType = (String)ref.getProperty("type");
            boolean algorithmTypeIsValidator = "validator".equals(algorithmType);
            String inDataType = (String)ref.getProperty("in_data");
            boolean inDataTypeIsFile = inDataType.startsWith(MIME_TYPE_PREFIX);
            String outDataType = (String)ref.getProperty("out_data");
            boolean outDataTypeIsFileExt = outDataType.startsWith(FILE_EXTENSION_PREFIX);
            return algorithmTypeIsValidator && inDataTypeIsFile && outDataTypeIsFileExt;
        }

        private String createErrorMessage(ServiceReference<AlgorithmFactory> ref, Throwable e) {
            String inType = (String)ConverterImpl.this.properties.get((Object)"in_data");
            String preProblemType = (String)ref.getProperty("in_data");
            String postProblemType = (String)ref.getProperty("out_data");
            String outType = (String)ConverterImpl.this.properties.get((Object)"out_data");
            if (inType.equals(preProblemType) && outType.equals(postProblemType)) {
                return "Problem converting data from " + this.prettifyDataType(inType) + " to " + this.prettifyDataType(outType) + " (See the log file for more details).:\n        " + e.getMessage();
            }
            return "Problem converting data from " + this.prettifyDataType(inType) + " to " + this.prettifyDataType(outType) + " during the necessary intermediate conversion from " + this.prettifyDataType(preProblemType) + " to " + this.prettifyDataType(postProblemType) + " (See the log file for more details):\n        " + e.getMessage();
        }

        private String prettifyDataType(String dataType) {
            if (dataType.startsWith(MIME_TYPE_PREFIX)) {
                return this.withoutFirstCharacters(dataType, MIME_TYPE_PREFIX.length());
            }
            if (dataType.startsWith(FILE_EXTENSION_PREFIX)) {
                return "." + this.withoutFirstCharacters(dataType, FILE_EXTENSION_PREFIX.length());
            }
            return dataType;
        }

        public String withoutFirstCharacters(String s, int n) {
            return s.substring(n);
        }
    }
}

