/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.service.conversion;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.io.GraphMLFile;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.AlgorithmProperty;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.conversion.ConverterImpl;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;
import org.cishell.service.conversion.DataConversionService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class DataConversionServiceImpl
implements DataConversionService,
AlgorithmProperty,
ServiceListener {
    public static final String SERVICE_LIST = "SERVICE_LIST";
    private BundleContext bContext;
    private CIShellContext ciContext;
    private Map<String, Vertex> dataTypeToVertex;
    private Graph graph;

    public DataConversionServiceImpl(BundleContext bContext, CIShellContext ciContext) {
        this.bContext = bContext;
        this.ciContext = ciContext;
        this.graph = new DirectedSparseGraph();
        this.dataTypeToVertex = new HashMap<String, Vertex>();
        String filter = "(&(type=converter)(in_data=*) (out_data=*)(!(remote=*))(!(in_data=file-ext:*))(!(out_data=file-ext:*)))";
        try {
            this.bContext.addServiceListener((ServiceListener)this, filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        this.assembleGraph();
    }

    private void assembleGraph() {
        try {
            String filter = "(&(type=converter)(in_data=*) (out_data=*)(!(remote=*))(!(in_data=file-ext:*))(!(out_data=file-ext:*)))";
            Collection<ServiceReference<AlgorithmFactory>> refs = this.getAFServiceReferences(filter);
            if (refs != null) {
                for (ServiceReference<AlgorithmFactory> ref : refs) {
                    String inData = (String)ref.getProperty("in_data");
                    String outData = (String)ref.getProperty("out_data");
                    this.addServiceReference(inData, outData, ref);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Converter[] findConverters(String inFormat, String outFormat) {
        if (inFormat != null && inFormat.length() > 0 && outFormat != null && outFormat.length() > 0) {
            Converter[] converters = null;
            if (outFormat.startsWith("file-ext:")) {
                converters = this.getConvertersByWildcard(inFormat, "file:*");
                converters = this.connectValidator((ConverterImpl[])converters, outFormat);
            } else {
                converters = this.getConvertersByWildcard(inFormat, outFormat);
            }
            return converters;
        }
        return new Converter[0];
    }

    private ConverterImpl[] connectValidator(ConverterImpl[] converters, String outFormat) {
        HashSet newConverters = Sets.newHashSet();
        HashSet formats = Sets.newHashSet();
        int i = 0;
        while (i < converters.length) {
            String format = (String)converters[i].getProperties().get("out_data");
            if (!formats.contains(format)) {
                String filter = "(&(type=validator)(!(remote=*))(in_data=" + format + ")" + "(" + "out_data" + "=" + outFormat + "))";
                try {
                    Collection<ServiceReference<AlgorithmFactory>> refs = this.getAFServiceReferences(filter);
                    if (refs != null && refs.size() > 0) {
                        for (ServiceReference<AlgorithmFactory> ref : refs) {
                            ArrayList chain = Lists.newArrayList(converters[i].getConverterList());
                            chain.add(ref);
                            newConverters.add(ConverterImpl.createConverter(this.bContext, this.ciContext, chain));
                        }
                        formats.add(format);
                    }
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return newConverters.toArray(new ConverterImpl[0]);
    }

    private Collection<ServiceReference<AlgorithmFactory>> getAFServiceReferences(String filter) throws InvalidSyntaxException {
        ArrayList refList = Lists.newArrayList();
        ServiceReference[] refArray = this.bContext.getServiceReferences(AlgorithmFactory.class.getName(), filter);
        if (refArray != null && refArray.length > 0) {
            refList.addAll(Arrays.asList(refArray));
        }
        return refList;
    }

    private Set<String> resolveDataWildcard(String formatString, String algorithmProperty) {
        String algorithmFilter;
        HashSet<String> expansions = new HashSet<String>();
        if (!formatString.contains("*")) {
            expansions.add(formatString);
            return expansions;
        }
        if (algorithmProperty.equals("in_data")) {
            algorithmFilter = this.createConverterFilterForInFormat(formatString);
        } else if (algorithmProperty.equals("out_data")) {
            algorithmFilter = this.createConverterFilterForOutFormat(formatString);
        } else {
            throw new IllegalArgumentException(String.format("Got algorithm property %s, expected one of AlgorithmProperty.{IN,OUT}_DATA", algorithmProperty));
        }
        try {
            Collection<ServiceReference<AlgorithmFactory>> matches = this.getAFServiceReferences(algorithmFilter);
            for (ServiceReference<AlgorithmFactory> match : matches) {
                expansions.add((String)match.getProperty(algorithmProperty));
            }
        }
        catch (InvalidSyntaxException e) {
            this.getLogger().log(2, String.format("Error while looking for %s: %s", formatString, e.getMessage()));
        }
        return expansions;
    }

    private LogService getLogger() {
        return (LogService)this.ciContext.getService(LogService.class.getName());
    }

    private ConverterImpl[] getConvertersByWildcard(String inFormat, String outFormat) {
        String outFormatRegex;
        Set<String> matchingInFileTypes = this.resolveDataWildcard(inFormat, "in_data");
        Set<String> matchingOutFileTypes = this.resolveDataWildcard(outFormat, "out_data");
        HashSet<ConverterImpl> possibleConverters = new HashSet<ConverterImpl>();
        if (outFormat.contains("*") && Pattern.matches(outFormatRegex = outFormat.replaceAll("[*]", ".*"), inFormat)) {
            possibleConverters.add(ConverterImpl.createNoOpConverter(this.bContext, this.ciContext, inFormat));
        }
        for (String srcDataType : matchingInFileTypes) {
            for (String destDataType : matchingOutFileTypes) {
                ConverterImpl converter = this.getConverter(srcDataType, destDataType);
                if (converter == null) continue;
                possibleConverters.add(converter);
            }
        }
        return possibleConverters.toArray(new ConverterImpl[0]);
    }

    private String createConverterFilterForOutFormat(String outFormat) {
        String outFilter = "(&(type=converter)(in_data=*) (out_data=" + outFormat + ")" + "(!(" + "remote" + "=*)))";
        return outFilter;
    }

    private String createConverterFilterForInFormat(String inFormat) {
        String inFilter = "(&(type=converter)(in_data=" + inFormat + ") " + "(" + "out_data" + "=*)" + "(!(" + "in_data" + "=file-ext:*))" + "(!(" + "remote" + "=*)))";
        return inFilter;
    }

    private ConverterImpl getConverter(String inType, String outType) {
        DijkstraShortestPath shortestPathAlg;
        List edgeList;
        Vertex sourceVertex = this.dataTypeToVertex.get(inType);
        Vertex targetVertex = this.dataTypeToVertex.get(outType);
        if (sourceVertex != null && targetVertex != null && (edgeList = (shortestPathAlg = new DijkstraShortestPath((ArchetypeGraph)this.graph)).getPath(sourceVertex, targetVertex)).size() > 0) {
            ArrayList serviceReferences = Lists.newArrayList();
            for (Edge edge : edgeList) {
                AbstractList converterList = (AbstractList)edge.getUserDatum((Object)SERVICE_LIST);
                serviceReferences.add((ServiceReference)converterList.get(0));
            }
            return ConverterImpl.createConverter(this.bContext, this.ciContext, serviceReferences);
        }
        return null;
    }

    public Converter[] findConverters(Data data, String outFormat) {
        if (data == null) {
            if ("null".equalsIgnoreCase(outFormat)) {
                return new Converter[]{ConverterImpl.createNoOpConverter(this.bContext, this.ciContext, outFormat)};
            }
            return new Converter[0];
        }
        String format = data.getFormat();
        HashSet<Converter> set = new HashSet<Converter>();
        Converter[] converters = new Converter[]{};
        if (format != null) {
            converters = this.findConverters(format, outFormat);
            set.addAll(new HashSet<Converter>(Arrays.asList(converters)));
        }
        if (!(data.getData() instanceof File) && data.getData() != null) {
            Class<?> dataClass = data.getData().getClass();
            for (Class c : this.getClassesFor(dataClass)) {
                converters = this.findConverters(c.getName(), outFormat);
                set.addAll(new HashSet<Converter>(Arrays.asList(converters)));
            }
        }
        return set.toArray(new Converter[0]);
    }

    protected Collection getClassesFor(Class clazz) {
        HashSet<Class> classes = new HashSet<Class>();
        Class<?>[] c = clazz.getInterfaces();
        int i = 0;
        while (i < c.length) {
            classes.addAll(this.getClassesFor(c[i]));
            ++i;
        }
        Class superC = clazz.getSuperclass();
        if (superC != Object.class) {
            if (superC != null) {
                classes.addAll(this.getClassesFor(superC));
            }
        } else {
            classes.add(superC);
        }
        classes.add(clazz);
        return classes;
    }

    public Data convert(Data inDM, String outFormat) throws ConversionException {
        String inFormat = inDM.getFormat();
        if (inFormat != null && inFormat.equals(outFormat)) {
            return inDM;
        }
        Converter[] converters = this.findConverters(inDM, outFormat);
        if (converters.length > 0) {
            inDM = converters[0].convert(inDM);
        }
        return inDM;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference inServiceRef = event.getServiceReference();
        String inDataType = (String)inServiceRef.getProperty("in_data");
        String outDataType = (String)inServiceRef.getProperty("out_data");
        if (event.getType() == 2) {
            this.removeServiceReference(inDataType, outDataType, inServiceRef);
            this.addServiceReference(inDataType, outDataType, inServiceRef);
        } else if (event.getType() == 1) {
            this.addServiceReference(inDataType, outDataType, inServiceRef);
        } else if (event.getType() == 4) {
            this.removeServiceReference(inDataType, outDataType, inServiceRef);
        }
    }

    private void removeServiceReference(String sourceDataType, String targetDataType, ServiceReference<?> serviceReference) {
        if (sourceDataType != null && targetDataType != null) {
            Edge edge;
            Vertex sourceVertex = this.dataTypeToVertex.get(sourceDataType);
            Vertex targetVertex = this.dataTypeToVertex.get(targetDataType);
            String pid = (String)serviceReference.getProperty("service.pid");
            if (sourceVertex != null && targetVertex != null && (edge = sourceVertex.findEdge(targetVertex)) != null) {
                AbstractList serviceList = (AbstractList)edge.getUserDatum((Object)SERVICE_LIST);
                Iterator refs = serviceList.iterator();
                while (refs.hasNext()) {
                    ServiceReference currentServiceReference = (ServiceReference)refs.next();
                    String currentPid = (String)currentServiceReference.getProperty("service.pid");
                    if (!pid.equals(currentPid)) continue;
                    refs.remove();
                }
                if (serviceList.isEmpty()) {
                    this.graph.removeEdge(edge);
                }
            }
        }
    }

    private void addServiceReference(String sourceDataType, String targetDataType, ServiceReference<?> serviceReference) {
        if (sourceDataType != null && sourceDataType.length() > 0 && targetDataType != null && targetDataType.length() > 0) {
            ArrayList serviceList;
            Vertex sourceVertex = this.getVertex(sourceDataType);
            Vertex targetVertex = this.getVertex(targetDataType);
            this.removeServiceReference(sourceDataType, targetDataType, serviceReference);
            Edge directedEdge = sourceVertex.findEdge(targetVertex);
            if (directedEdge == null) {
                directedEdge = new DirectedSparseEdge(sourceVertex, targetVertex);
                this.graph.addEdge(directedEdge);
            }
            if ((serviceList = (ArrayList)directedEdge.getUserDatum((Object)SERVICE_LIST)) == null) {
                serviceList = new ArrayList();
                ((AbstractList)serviceList).add(serviceReference);
            }
            directedEdge.setUserDatum((Object)SERVICE_LIST, serviceList, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        }
    }

    private Vertex getVertex(String dataType) {
        SparseVertex vertex = (SparseVertex)this.dataTypeToVertex.get(dataType);
        if (vertex == null) {
            vertex = new SparseVertex();
            vertex.addUserDatum((Object)"label", (Object)dataType, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            this.graph.addVertex((Vertex)vertex);
            this.dataTypeToVertex.put(dataType, (Vertex)vertex);
        }
        return vertex;
    }

    private void saveGraph() {
        GraphMLFile writer = new GraphMLFile();
        Graph g = (Graph)this.graph.copy();
        for (Edge e : g.getEdges()) {
            e.removeUserDatum((Object)SERVICE_LIST);
        }
        writer.save(g, String.valueOf(System.getProperty("user.home")) + File.separator + "convertGraph.xml");
    }
}

