/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.templates.jythonrunner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import org.python.core.PyFile;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class JythonInterpreterInitializer {
    protected LogService logger;

    public JythonInterpreterInitializer(LogService logger) {
        this.logger = logger;
    }

    public PythonInterpreter initializeInterpreter(PythonInterpreter interp, Data[] data, Dictionary parameters) {
        interp = this.passUserProvidedArguments(interp, parameters);
        interp = this.passCIShellProvidedArguments(interp, data);
        interp = this.initializeLogging(interp);
        return interp;
    }

    protected PythonInterpreter passUserProvidedArguments(PythonInterpreter interp, Dictionary parameters) {
        Enumeration enumer = parameters.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            Object value = parameters.get(key);
            String argName = key;
            interp = this.passArgument(value, argName, interp);
        }
        return interp;
    }

    protected PythonInterpreter passCIShellProvidedArguments(PythonInterpreter interp, Data[] data) {
        int ii = 0;
        while (ii < data.length) {
            Data argData = data[ii];
            Object arg = argData.getData();
            String argName = "arg" + ii;
            interp = this.passArgument(arg, argName, interp);
            ++ii;
        }
        return interp;
    }

    protected PythonInterpreter initializeLogging(PythonInterpreter interp) {
        interp.setErr((OutputStream)System.err);
        interp.setOut((OutputStream)System.out);
        return interp;
    }

    protected PythonInterpreter passArgument(Object arg, String argName, PythonInterpreter interp) {
        if (!(arg instanceof File)) {
            interp.set(argName, (PyObject)new PyJavaInstance(arg));
        } else {
            try {
                File fileArg = (File)arg;
                InputStream fileStream = fileArg.toURL().openStream();
                interp.set(argName, (PyObject)new PyFile(fileStream));
            }
            catch (IOException e) {
                this.logger.log(1, "Problem opening file provided as an argument to jython script.", (Throwable)e);
                e.printStackTrace();
            }
        }
        return interp;
    }
}

