/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.templates.jythonrunner;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class JythonResultFormatter {
    public static final String DEFAULT_LABEL_VALUE = "Data";
    protected LogService logger;

    public JythonResultFormatter(LogService logger) {
        this.logger = logger;
    }

    public Data[] formatRawResults(List rawResults, Data[] inputData, Dictionary properties) {
        List dataResults = this.convertToData(rawResults, properties);
        dataResults = this.addMetaData(dataResults, inputData, properties);
        Data[] resultsArray = this.convertToArray(dataResults);
        return resultsArray;
    }

    protected List addMetaData(List data, Data[] inputData, Dictionary properties) {
        ArrayList<Data> results = new ArrayList<Data>();
        int ii = 0;
        while (ii < data.size()) {
            Data result = (Data)data.get(ii);
            Dictionary metadataHolder = result.getMetadata();
            String dataLabel = this.getResultLabel(properties, ii);
            metadataHolder.put("Label", dataLabel);
            String dataType = this.getResultType(properties, ii);
            metadataHolder.put("Type", dataType);
            Data dataParent = this.getResultParent(properties, ii, inputData);
            if (dataParent != null) {
                metadataHolder.put("Parent", dataParent);
            }
            results.add(result);
            ++ii;
        }
        return results;
    }

    protected String getResultLabel(Dictionary props, int numResult) {
        String labelValueString;
        String labelKey = "result" + numResult + ".label";
        Object labelValue = props.get(labelKey);
        if (labelValue != null) {
            labelValueString = (String)labelValue;
        } else {
            labelValueString = DEFAULT_LABEL_VALUE;
            this.logger.log(2, "Label of data returned from jython script not specified in .properties file. Assigning label to '" + labelValueString + "'.");
        }
        return labelValueString;
    }

    protected String getResultType(Dictionary props, int numResult) {
        String typeValueString;
        String typeKey = "result" + numResult + ".type";
        Object typeValue = props.get(typeKey);
        if (typeValue != null) {
            typeValueString = (String)typeValue;
            this.checkType(typeValueString);
        } else {
            typeValueString = "Unknown";
            this.logger.log(2, "Type of data returned from jython script not specified in .properties file. Assigning type to '" + typeValueString + "'.");
        }
        return typeValueString;
    }

    protected Data getResultParent(Dictionary props, int numResult, Data[] inputData) {
        Data parent;
        String childKey = "result" + numResult + ".parent";
        Object parentName = props.get(childKey);
        if (parentName != null) {
            char parentDataIndexChar = this.getLastChar((String)parentName);
            int parentDataIndex = Character.digit(parentDataIndexChar, 10);
            if (parentDataIndex < inputData.length) {
                parent = inputData[parentDataIndex];
            } else {
                this.logger.log(2, ".properties file tried to assign result" + numResult + "the " + "parent arg" + parentDataIndex + ", which has an " + "index greater than any arg provided. Cannot " + "assign result" + numResult + " a parent.");
                parent = null;
            }
        } else {
            parent = null;
        }
        return parent;
    }

    protected List convertToData(List rawResults, Dictionary props) {
        int numFinalResults;
        ArrayList<BasicData> results = new ArrayList<BasicData>();
        String outData = (String)props.get("out_data");
        if (outData.trim().equalsIgnoreCase("null")) {
            return results;
        }
        String[] formats = outData.split(",");
        if (formats.length > rawResults.size()) {
            numFinalResults = rawResults.size();
            this.logger.log(2, "More out_data formats provided than an actual data returned. Ignoring extra formats.");
        } else if (rawResults.size() > formats.length) {
            numFinalResults = formats.length;
            this.logger.log(2, "More data returned than out_data formats provided. Ignoring additional data returned");
        } else {
            numFinalResults = rawResults.size();
        }
        int ii = 0;
        while (ii < numFinalResults) {
            Object rawResult = rawResults.get(ii);
            BasicData data = new BasicData(rawResult, formats[ii]);
            results.add(data);
            ++ii;
        }
        return results;
    }

    protected char getLastChar(String s) {
        if (s.length() > 0) {
            return s.charAt(s.length() - 1);
        }
        throw new IndexOutOfBoundsException("Cannot get the last character of an empty string");
    }

    protected Data[] convertToArray(List dataList) {
        Data[] dataArray = new Data[dataList.size()];
        int ii = 0;
        while (ii < dataArray.length) {
            dataArray[ii] = (Data)dataList.get(ii);
            ++ii;
        }
        return dataArray;
    }

    protected void checkType(String ts) {
        if (!(ts.equals("Matrix") || ts.equals("Network") || ts.equals("Text") || ts.equals("Unknown"))) {
            this.logger.log(2, "JythonRunnerAlgorithm: Assigning return data an unsupported data type " + ts + ". Either the type is invalid or " + "JythonRunnerAlgorithm has not be updated to reflect " + "types introduced in newer versions");
        }
    }
}

