/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.templates.jythonrunner;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;
import org.cishell.templates.jythonrunner.JythonInterpreterInitializer;
import org.cishell.templates.jythonrunner.JythonResultFormatter;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class JythonRunnerAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary parameters;
    private Dictionary properties;
    private LogService logger;
    private URL script;
    private JythonInterpreterInitializer interpInitializer;
    private JythonResultFormatter resultFormatter;

    public JythonRunnerAlgorithm(Data[] data, Dictionary parameters, CIShellContext context, Dictionary properties, Bundle myBundle) {
        this.data = data;
        this.parameters = parameters;
        this.properties = properties;
        String scriptPath = (String)properties.get("script_path");
        this.script = myBundle.getResource(scriptPath);
        this.logger = (LogService)context.getService(LogService.class.getName());
        this.interpInitializer = new JythonInterpreterInitializer(this.logger);
        this.resultFormatter = new JythonResultFormatter(this.logger);
    }

    public Data[] execute() {
        PythonInterpreter interp = this.interpInitializer.initializeInterpreter(new PythonInterpreter(), this.data, this.parameters);
        List rawResults = this.runScript(interp, this.script);
        Data[] results = this.resultFormatter.formatRawResults(rawResults, this.data, this.properties);
        return results;
    }

    private List runScript(PythonInterpreter interp, URL script) {
        interp = this.executeFile(interp, script);
        List rawResults = this.getRawResults(interp);
        return rawResults;
    }

    private PythonInterpreter executeFile(PythonInterpreter interp, URL script) {
        try {
            interp.execfile(script.openStream());
        }
        catch (IOException e) {
            this.logger.log(1, "Unable to open jython script " + script.toString() + ".", (Throwable)e);
            e.printStackTrace();
        }
        return interp;
    }

    protected List getRawResults(PythonInterpreter interp) {
        ArrayList<Object> results = new ArrayList<Object>();
        int ii = 0;
        String resultName = "result" + ii;
        while (this.variableIsDefined(interp, resultName)) {
            results.add(interp.get(resultName, Object.class));
            resultName = "result" + ++ii;
        }
        return results;
    }

    protected boolean variableIsDefined(PythonInterpreter interp, String variableName) {
        String predicate = "vars().has_key('" + variableName + "') or " + "globals().has_key('" + variableName + "')";
        boolean result = this.evalPredicate(interp, predicate);
        return result;
    }

    protected boolean evalPredicate(PythonInterpreter interp, String predicate) {
        PyObject pyResult = interp.eval(predicate);
        Boolean resultObj = (Boolean)pyResult.__tojava__(Boolean.class);
        boolean result = resultObj;
        return result;
    }
}

