/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.templates.dataset;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.templates.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeProvider;

public class DatasetFactory
implements AlgorithmFactory {
    protected File datasetFile;
    protected BundleContext bContext;
    protected String datasetPath;
    protected String format;
    protected String label;

    protected void activate(ComponentContext ctxt) {
        try {
            this.bContext = ctxt.getBundleContext();
            this.datasetPath = (String)ctxt.getProperties().get("dataset");
            this.format = (String)ctxt.getProperties().get("out_data");
            this.label = (String)ctxt.getProperties().get("label");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        this.bContext = null;
        this.datasetPath = null;
        this.datasetFile = null;
        this.format = null;
        this.label = null;
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new DatasetAlgorithm(context);
    }

    public MetaTypeProvider createParameters(Data[] data) {
        return null;
    }

    protected File getDataset() throws IOException {
        if (this.datasetFile == null || !this.datasetFile.exists()) {
            this.datasetFile = this.copyFile(Activator.getTempDirectory(), this.datasetPath);
        }
        return this.datasetFile;
    }

    private File copyFile(File dir, String path) throws IOException {
        URL entry = this.bContext.getBundle().getEntry(path);
        path = path.replace('/', File.separatorChar);
        File outFile = File.createTempFile(String.valueOf(this.getName(path)) + "-", ".tmp", dir);
        FileOutputStream outStream = new FileOutputStream(outFile);
        ReadableByteChannel in = Channels.newChannel(entry.openStream());
        FileChannel out = outStream.getChannel();
        out.transferFrom(in, 0L, Integer.MAX_VALUE);
        in.close();
        out.close();
        return outFile;
    }

    private String getName(String path) {
        if (path.lastIndexOf(File.separator) == path.length() - 1) {
            path = path.substring(0, path.length() - 1);
        }
        path = path.substring(path.lastIndexOf(File.separatorChar) + 1, path.length());
        return path;
    }

    private class DatasetAlgorithm
    implements Algorithm {
        CIShellContext ciContext;

        public DatasetAlgorithm(CIShellContext ciContext) {
            this.ciContext = ciContext;
        }

        public Data[] execute() throws AlgorithmExecutionException {
            try {
                BasicData data = new BasicData((Object)DatasetFactory.this.getDataset(), DatasetFactory.this.format);
                data.getMetadata().put("Label", DatasetFactory.this.label);
                return new Data[]{data};
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
        }
    }
}

