/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.templates.staticexecutable;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.Data;
import org.cishell.templates.staticexecutable.StaticExecutableRunner;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class StaticExecutableAlgorithm
implements Algorithm,
ProgressTrackable {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;
    LogService logger;
    private BundleContext bContext;
    private String algName;
    private ProgressMonitor monitor;

    public StaticExecutableAlgorithm(Data[] data, Dictionary parameters, CIShellContext context, BundleContext bContext, String algName) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.bContext = bContext;
        this.algName = algName;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Properties serviceProps = this.getProperties("/" + this.algName + "/service.properties");
            Properties configProps = this.getProperties("/" + this.algName + "/config.properties");
            serviceProps.putAll((Map<?, ?>)configProps);
            serviceProps.put("Algorithm-Directory", this.algName);
            StaticExecutableRunner runner = new StaticExecutableRunner(this.bContext, this.context, serviceProps, this.parameters, this.data, this.monitor, this.algName);
            return runner.execute();
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Properties getProperties(String entry) throws IOException {
        URL url = this.bContext.getBundle().getEntry(entry);
        Properties props = null;
        if (url != null) {
            props = new Properties();
            props.load(url.openStream());
        }
        return props;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

