/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.templates.staticexecutable;

import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;
import org.cishell.templates.staticexecutable.StaticExecutableAlgorithm;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;

public class StaticExecutableAlgorithmFactory
implements AlgorithmFactory {
    BundleContext bContext;
    String algName;
    MetaTypeProvider provider;

    public StaticExecutableAlgorithmFactory() {
    }

    protected void activate(ComponentContext ctxt) {
        this.bContext = ctxt.getBundleContext();
        this.algName = (String)ctxt.getProperties().get("Algorithm-Directory");
        try {
            MetaTypeService mts = (MetaTypeService)ctxt.locateService("MTS");
            this.provider = mts.getMetaTypeInformation(ctxt.getBundleContext().getBundle());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        this.bContext = null;
        this.algName = null;
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new StaticExecutableAlgorithm(data, parameters, context, this.bContext, this.algName);
    }

    public MetaTypeProvider createParameters(Data[] data) {
        return this.provider;
    }

    public StaticExecutableAlgorithmFactory(String algName, BundleContext bContext) {
        this.algName = algName;
        this.bContext = bContext;
    }
}

